/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.datagen;

import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.block.custom.FencePoleBlock;
import net.cmr.jurassicrevived.block.custom.FenceWireBlock;
import net.cmr.jurassicrevived.block.custom.PipeBlock;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "jurassicrevived", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)ModBlocks.ROYAL_FERN.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)ModBlocks.ROYAL_FERN.get()).getPath(), this.blockTexture((Block)ModBlocks.ROYAL_FERN.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.POTTED_ROYAL_FERN.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_royal_fern", ResourceLocation.parse((String)"flower_pot_cross"), "plant", this.blockTexture((Block)ModBlocks.ROYAL_FERN.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.HORSETAIL_FERN.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)ModBlocks.HORSETAIL_FERN.get()).getPath(), this.blockTexture((Block)ModBlocks.HORSETAIL_FERN.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.POTTED_HORSETAIL_FERN.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_horsetail_fern", ResourceLocation.parse((String)"flower_pot_cross"), "plant", this.blockTexture((Block)ModBlocks.HORSETAIL_FERN.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.WESTERN_SWORD_FERN.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)ModBlocks.WESTERN_SWORD_FERN.get()).getPath(), this.blockTexture((Block)ModBlocks.WESTERN_SWORD_FERN.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.POTTED_WESTERN_SWORD_FERN.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_western_sword_fern", ResourceLocation.parse((String)"flower_pot_cross"), "plant", this.blockTexture((Block)ModBlocks.WESTERN_SWORD_FERN.get()))).renderType("cutout"));
        this.blockWithItem(ModBlocks.GYPSUM_STONE);
        this.blockWithItem(ModBlocks.GYPSUM_COBBLESTONE);
        this.blockWithItem(ModBlocks.GYPSUM_STONE_BRICKS);
        this.blockWithItem(ModBlocks.SMOOTH_GYPSUM_STONE);
        this.blockWithItem(ModBlocks.STONE_FOSSIL);
        this.blockWithItem(ModBlocks.DEEPSLATE_FOSSIL);
        this.blockWithItem(ModBlocks.AMBER_ORE);
        this.blockWithItem(ModBlocks.DEEPSLATE_ICE_SHARD_ORE);
        this.blockWithItem(ModBlocks.REINFORCED_STONE);
        this.blockWithItem(ModBlocks.REINFORCED_STONE_BRICKS);
        this.horizontalFacingWithItem(ModBlocks.CAT_PLUSHIE);
        this.horizontalFacingWithItem(ModBlocks.GENERATOR);
        this.horizontalFacingWithItem(ModBlocks.DNA_EXTRACTOR);
        this.horizontalFacingWithItem(ModBlocks.FOSSIL_GRINDER);
        this.horizontalFacingWithItem(ModBlocks.FOSSIL_CLEANER);
        this.horizontalFacingWithItem(ModBlocks.DNA_HYBRIDIZER);
        this.horizontalFacingWithItem(ModBlocks.EMBRYONIC_MACHINE);
        this.horizontalFacingWithItem(ModBlocks.EMBRYO_CALCIFICATION_MACHINE);
        this.horizontalFacingWithItem(ModBlocks.INCUBATOR);
        this.eggLike(ModBlocks.HATCHED_VELOCIRAPTOR_EGG);
        this.eggLike(ModBlocks.HATCHED_TYRANNOSAURUS_REX_EGG);
        this.eggLike(ModBlocks.HATCHED_TRICERATOPS_EGG);
        this.eggLike(ModBlocks.HATCHED_SPINOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_OURANOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_PARASAUROLOPHUS_EGG);
        this.eggLike(ModBlocks.HATCHED_INDOMINUS_REX_EGG);
        this.eggLike(ModBlocks.HATCHED_GALLIMIMUS_EGG);
        this.eggLike(ModBlocks.HATCHED_DIPLODOCUS_EGG);
        this.eggLike(ModBlocks.HATCHED_DILOPHOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_COMPSOGNATHUS_EGG);
        this.eggLike(ModBlocks.HATCHED_CERATOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_BRACHIOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_ALBERTOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_APATOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_BARYONYX_EGG);
        this.eggLike(ModBlocks.HATCHED_CARNOTAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_CONCAVENATOR_EGG);
        this.eggLike(ModBlocks.HATCHED_DEINONYCHUS_EGG);
        this.eggLike(ModBlocks.HATCHED_EDMONTOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_GIGANOTOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_GUANLONG_EGG);
        this.eggLike(ModBlocks.HATCHED_HERRERASAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_MAJUNGASAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_PROCOMPSOGNATHUS_EGG);
        this.eggLike(ModBlocks.HATCHED_PROTOCERATOPS_EGG);
        this.eggLike(ModBlocks.HATCHED_RUGOPS_EGG);
        this.eggLike(ModBlocks.HATCHED_SHANTUNGOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_STEGOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_STYRACOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_THERIZINOSAURUS_EGG);
        this.eggLike(ModBlocks.HATCHED_DISTORTUS_REX_EGG);
        this.customFenceMultipart(ModBlocks.LOW_SECURITY_FENCE_POLE, "low_security_fence_pole", "low_security_fence_pole_part", "low_security_fence_pole_diagonal_part", FencePoleBlock.NE, FencePoleBlock.SE, FencePoleBlock.SW, FencePoleBlock.NW);
        this.customFenceMultipart(ModBlocks.LOW_SECURITY_FENCE_WIRE, "low_security_fence_wire", "low_security_fence_wire_part", "low_security_fence_wire_diagonal_part", FenceWireBlock.NE, FenceWireBlock.SE, FenceWireBlock.SW, FenceWireBlock.NW);
        this.customFenceMultipart(ModBlocks.MEDIUM_SECURITY_FENCE_POLE, "medium_security_fence_pole", "medium_security_fence_pole_part", "medium_security_fence_pole_diagonal_part", FencePoleBlock.NE, FencePoleBlock.SE, FencePoleBlock.SW, FencePoleBlock.NW);
        this.customFenceMultipart(ModBlocks.MEDIUM_SECURITY_FENCE_WIRE, "medium_security_fence_wire", "medium_security_fence_wire_part", "medium_security_fence_wire_diagonal_part", FenceWireBlock.NE, FenceWireBlock.SE, FenceWireBlock.SW, FenceWireBlock.NW);
        this.pipeMultipartWithItem(ModBlocks.ITEM_PIPE, "item_pipe");
        this.pipeMultipartWithItem(ModBlocks.FLUID_PIPE, "fluid_pipe");
        this.pipeMultipartWithItem(ModBlocks.POWER_PIPE, "power_pipe");
    }

    private void blockWithItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("jurassicrevived:block/" + deferredBlock.getId().getPath()));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("jurassicrevived:block/" + deferredBlock.getId().getPath() + appendix));
    }

    private void horizontalFacingWithItem(DeferredBlock<Block> block) {
        ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.modLoc("block/" + block.getId().getPath()));
        this.horizontalBlock((Block)block.get(), (ModelFile)model);
        this.simpleBlockItem((Block)block.get(), (ModelFile)model);
    }

    private void eggLike(DeferredBlock<Block> block) {
        ModelFile.UncheckedModelFile eggModel = new ModelFile.UncheckedModelFile(this.modLoc("block/egg"));
        this.simpleBlock((Block)block.get(), (ModelFile)eggModel);
    }

    private void pipeMultipartWithItem(DeferredBlock<? extends Block> regBlock, String modelBaseName) {
        this.pipeMultipart(regBlock, modelBaseName);
        ModelFile.UncheckedModelFile itemParent = new ModelFile.UncheckedModelFile(this.modLoc("block/" + modelBaseName));
        this.simpleBlockItem((Block)regBlock.get(), (ModelFile)itemParent);
    }

    private void pipeMultipart(DeferredBlock<? extends Block> regBlock, String modelBaseName) {
        Block block = (Block)regBlock.get();
        MultiPartBlockStateBuilder multipart = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + modelBaseName))).addModel()).end();
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_interchange", PipeBlock.UP, PipeBlock.ConnectionType.PIPE, 90, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_interchange", PipeBlock.DOWN, PipeBlock.ConnectionType.PIPE, 270, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_interchange", PipeBlock.NORTH, PipeBlock.ConnectionType.PIPE, 0, 180);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_interchange", PipeBlock.EAST, PipeBlock.ConnectionType.PIPE, 0, 270);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_interchange", PipeBlock.SOUTH, PipeBlock.ConnectionType.PIPE, 0, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_interchange", PipeBlock.WEST, PipeBlock.ConnectionType.PIPE, 0, 90);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector", PipeBlock.UP, PipeBlock.ConnectionType.CONNECTOR, 90, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector", PipeBlock.DOWN, PipeBlock.ConnectionType.CONNECTOR, 270, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector", PipeBlock.NORTH, PipeBlock.ConnectionType.CONNECTOR, 0, 180);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector", PipeBlock.EAST, PipeBlock.ConnectionType.CONNECTOR, 0, 270);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector", PipeBlock.SOUTH, PipeBlock.ConnectionType.CONNECTOR, 0, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector", PipeBlock.WEST, PipeBlock.ConnectionType.CONNECTOR, 0, 90);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector_pull", PipeBlock.UP, PipeBlock.ConnectionType.CONNECTOR_PULL, 90, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector_pull", PipeBlock.DOWN, PipeBlock.ConnectionType.CONNECTOR_PULL, 270, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector_pull", PipeBlock.NORTH, PipeBlock.ConnectionType.CONNECTOR_PULL, 0, 180);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector_pull", PipeBlock.EAST, PipeBlock.ConnectionType.CONNECTOR_PULL, 0, 270);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector_pull", PipeBlock.SOUTH, PipeBlock.ConnectionType.CONNECTOR_PULL, 0, 0);
        this.addDirectionalEnumPart(multipart, "block/" + modelBaseName + "_connector_pull", PipeBlock.WEST, PipeBlock.ConnectionType.CONNECTOR_PULL, 0, 90);
    }

    private void addDirectionalEnumPart(MultiPartBlockStateBuilder multipart, String modelPath, EnumProperty<PipeBlock.ConnectionType> prop, PipeBlock.ConnectionType value, int rotX, int rotY) {
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelPath))).rotationX(rotX).rotationY(rotY).addModel()).condition(prop, (Comparable[])new PipeBlock.ConnectionType[]{value}).end();
    }

    private void customFenceMultipart(DeferredBlock<? extends Block> block, String baseModelName, String straightArmModelName, String diagonalArmModelName, BooleanProperty neProp, BooleanProperty seProp, BooleanProperty swProp, BooleanProperty nwProp) {
        MultiPartBlockStateBuilder multipart = this.getMultipartBuilder((Block)block.get());
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + baseModelName))).addModel()).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + straightArmModelName))).rotationY(0).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + straightArmModelName))).rotationY(90).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + straightArmModelName))).rotationY(180).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + straightArmModelName))).rotationY(270).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + diagonalArmModelName))).rotationY(90).addModel()).condition((Property)neProp, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + diagonalArmModelName))).rotationY(180).addModel()).condition((Property)seProp, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + diagonalArmModelName))).rotationY(270).addModel()).condition((Property)swProp, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)multipart.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + diagonalArmModelName))).rotationY(0).addModel()).condition((Property)nwProp, (Comparable[])new Boolean[]{true}).end();
    }
}

