/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class ModGlobalLootModifierProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final List<Entry> entries = new ArrayList<Entry>();

    public ModGlobalLootModifierProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public ModGlobalLootModifierProvider addBrushItem(String fileName, ResourceLocation itemId, float chance, ResourceLocation lootTableId) {
        this.entries.add(new Entry(fileName, itemId, chance, lootTableId));
        return this;
    }

    public ModGlobalLootModifierProvider addBrushItemForTables(String baseFileName, ResourceLocation itemId, float chance, ResourceLocation ... lootTableIds) {
        for (ResourceLocation id : lootTableIds) {
            String suffix = id.getNamespace() + "_" + id.getPath().replace('/', '_');
            String fileName = baseFileName + "_" + suffix;
            this.addBrushItem(fileName, itemId, chance, id);
        }
        return this;
    }

    public ModGlobalLootModifierProvider addBrushItemForAllArchaeologyTables(String baseFileName, ResourceLocation itemId, float chance) {
        return this.addBrushItemForTables(baseFileName, itemId, chance, ResourceLocation.parse((String)"minecraft:archaeology/desert_pyramid"), ResourceLocation.parse((String)"minecraft:archaeology/trail_ruins_common"), ResourceLocation.parse((String)"minecraft:archaeology/trail_ruins_rare"), ResourceLocation.parse((String)"minecraft:archaeology/ocean_ruin_cold"), ResourceLocation.parse((String)"minecraft:archaeology/ocean_ruin_warm"), ResourceLocation.parse((String)"minecraft:archaeology/desert_well"));
    }

    public ModGlobalLootModifierProvider addBrushItemForAllArchaeologyTables(String baseFileName, ItemLike item, float chance) {
        ResourceLocation id = item.asItem().builtInRegistryHolder().key().location();
        return this.addBrushItemForAllArchaeologyTables(baseFileName, id, chance);
    }

    public CompletableFuture<?> run(CachedOutput output) {
        PackOutput.PathProvider modPathProvider = this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_modifiers");
        PackOutput.PathProvider neoforgePathProvider = this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_modifiers");
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        JsonArray manifestEntries = new JsonArray();
        for (Entry e : this.entries) {
            JsonObject root = new JsonObject();
            root.addProperty("type", "jurassicrevived:add_item");
            JsonArray conditions = new JsonArray();
            JsonObject byTable = new JsonObject();
            byTable.addProperty("condition", "neoforge:loot_table_id");
            byTable.addProperty("loot_table_id", e.lootTableId().toString());
            conditions.add((JsonElement)byTable);
            root.add("conditions", (JsonElement)conditions);
            JsonObject item = new JsonObject();
            item.addProperty("id", e.itemId().toString());
            item.addProperty("Count", (Number)1);
            root.add("item", (JsonElement)item);
            root.addProperty("chance", (Number)Float.valueOf(e.chance()));
            Path path = modPathProvider.json(ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)e.fileName()));
            futures.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)root, (Path)path));
            manifestEntries.add("jurassicrevived:" + e.fileName());
        }
        JsonObject manifest = new JsonObject();
        manifest.addProperty("replace", Boolean.valueOf(false));
        manifest.add("entries", (JsonElement)manifestEntries);
        Path manifestPath = neoforgePathProvider.json(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"global_loot_modifiers"));
        futures.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)manifest, (Path)manifestPath));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "JR Global Loot Modifiers";
    }

    private record Entry(String fileName, ResourceLocation itemId, float chance, ResourceLocation lootTableId) {
    }
}

