/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.datagen.custom;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.cmr.jurassicrevived.item.ModItems;
import net.cmr.jurassicrevived.recipe.FossilGrinderRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class FossilGrindingRecipeBuilder {
    private Optional<ItemLike> inputItem = Optional.empty();
    private Optional<Item> resultItem = Optional.empty();
    private final int count;
    private final Map<String, Criterion<?>> criteria;
    private final Map<ResourceLocation, Integer> weights = new HashMap<ResourceLocation, Integer>();

    public FossilGrindingRecipeBuilder(ItemLike input, ItemLike result, int count) {
        this.inputItem = Optional.of(input);
        this.resultItem = Optional.of(result.asItem());
        this.count = count;
        this.criteria = new LinkedHashMap();
    }

    public static FossilGrindingRecipeBuilder fossilWeighted(ItemLike fossil, ItemLike tissueResult, int count) {
        FossilGrindingRecipeBuilder b = new FossilGrindingRecipeBuilder(fossil, tissueResult, count);
        b.addWeightedOutput((ItemLike)Items.BONE_MEAL, 30).addWeightedOutput((ItemLike)Items.FLINT, 30).addWeightedOutput((ItemLike)ModItems.CRUSHED_FOSSIL.get(), 30).addWeightedOutput(tissueResult, 10);
        return b;
    }

    public static FossilGrindingRecipeBuilder skullToTissue(ItemLike skull, ItemLike tissueResult, int count) {
        return new FossilGrindingRecipeBuilder(skull, tissueResult, count);
    }

    public FossilGrindingRecipeBuilder addWeightedOutput(ItemLike item, int weight) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        if (id != null) {
            this.weights.put(id, Math.max(0, weight));
        }
        return this;
    }

    public void saveFossil(RecipeOutput output) {
        ResourceLocation resultKey = BuiltInRegistries.ITEM.getKey((Object)this.resultItem.orElseThrow());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)resultKey.getNamespace(), (String)(resultKey.getPath() + "_from_fossil_grinding"));
        this.save(output, id);
    }

    public void saveSkull(RecipeOutput output) {
        ResourceLocation resultKey = BuiltInRegistries.ITEM.getKey((Object)this.resultItem.orElseThrow());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)resultKey.getNamespace(), (String)(resultKey.getPath() + "_from_skull_grinding"));
        this.save(output, id);
    }

    public void save(RecipeOutput output, ResourceLocation recipeId) {
        NonNullList inputs = NonNullList.create();
        inputs.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{this.inputItem.orElseThrow()}));
        ItemStack result = new ItemStack((ItemLike)this.resultItem.orElseThrow(), this.count);
        FossilGrinderRecipe recipe = new FossilGrinderRecipe((NonNullList<Ingredient>)inputs, result, Map.copyOf(this.weights));
        AdvancementHolder advancementHolder = null;
        if (!this.criteria.isEmpty()) {
            Advancement.Builder builder = output.advancement();
            for (Map.Entry<String, Criterion<?>> e : this.criteria.entrySet()) {
                builder.addCriterion(e.getKey(), e.getValue());
            }
            builder.rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId));
            builder.requirements(AdvancementRequirements.Strategy.OR);
            advancementHolder = builder.build(recipeId.withPrefix("recipes/"));
        }
        output.accept(recipeId, (Recipe)recipe, advancementHolder);
    }

    public FossilGrindingRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }
}

