/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.entity.custom;

import net.cmr.jurassicrevived.entity.ModEntities;
import net.cmr.jurassicrevived.entity.ai.SprintingMeleeAttackGoal;
import net.cmr.jurassicrevived.entity.client.DistortusRexVariant;
import net.cmr.jurassicrevived.entity.custom.BrachiosaurusEntity;
import net.cmr.jurassicrevived.entity.custom.CeratosaurusEntity;
import net.cmr.jurassicrevived.entity.custom.DilophosaurusEntity;
import net.cmr.jurassicrevived.entity.custom.GallimimusEntity;
import net.cmr.jurassicrevived.entity.custom.IndominusRexEntity;
import net.cmr.jurassicrevived.entity.custom.ParasaurolophusEntity;
import net.cmr.jurassicrevived.entity.custom.SpinosaurusEntity;
import net.cmr.jurassicrevived.entity.custom.TriceratopsEntity;
import net.cmr.jurassicrevived.entity.custom.VelociraptorEntity;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DistortusRexEntity
extends Animal
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(DistortusRexEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float tailSwayOffset;
    private float tailSwayVelocity;
    private float tailSwayPrev;
    private int mouthAnimCooldown = 0;

    public DistortusRexEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, BrachiosaurusEntity.class, 20.0f, 1.0, 1.0));
        this.goalSelector.addGoal(4, (Goal)new SprintingMeleeAttackGoal(this, (PathfinderMob)this, 1.25, false){

            private double getAttackReachSqr(LivingEntity entity) {
                return 25.0;
            }
        });
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new FollowMobGoal((Mob)this, 1.2, 20.0f, 10.0f));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, target -> target.getType() != this.getType()));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, TriceratopsEntity.class, false, false));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, GallimimusEntity.class, false, false));
        this.targetSelector.addGoal(14, (Goal)new NearestAttackableTargetGoal((Mob)this, DilophosaurusEntity.class, false, false));
        this.targetSelector.addGoal(15, (Goal)new NearestAttackableTargetGoal((Mob)this, CeratosaurusEntity.class, false, false));
        this.targetSelector.addGoal(16, (Goal)new NearestAttackableTargetGoal((Mob)this, ParasaurolophusEntity.class, false, false));
        this.targetSelector.addGoal(17, (Goal)new NearestAttackableTargetGoal((Mob)this, VelociraptorEntity.class, false, false));
        this.targetSelector.addGoal(18, (Goal)new NearestAttackableTargetGoal((Mob)this, SpinosaurusEntity.class, false, false));
        this.targetSelector.addGoal(19, (Goal)new NearestAttackableTargetGoal((Mob)this, IndominusRexEntity.class, false, false));
        this.targetSelector.addGoal(20, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(21, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ARMOR, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_DAMAGE, 35.0);
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(Items.BEEF);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        AgeableMob child = (AgeableMob)ModEntities.DISTORTUS_REX.get().create((Level)pLevel);
        if (child instanceof DistortusRexEntity) {
            DistortusRexEntity baby = (DistortusRexEntity)child;
            DistortusRexVariant randomVariant = (DistortusRexVariant)((Object)Util.getRandom((Object[])DistortusRexVariant.values(), (RandomSource)this.random));
            baby.setVariant(randomVariant);
        }
        return child;
    }

    public boolean doHurtTarget(Entity target) {
        Level level;
        boolean hit = super.doHurtTarget(target);
        if (!this.level().isClientSide && hit && target instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim("attackController", "attack");
        }
        return hit;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.isSprinting() ? RawAnimation.begin().then("anim.distortus_rex.walk", Animation.LoopType.LOOP) : RawAnimation.begin().then("anim.distortus_rex.walk", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("anim.distortus_rex.idle", Animation.LoopType.LOOP));
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", state -> PlayState.STOP).triggerableAnim("attack", RawAnimation.begin().then("anim.distortus_rex.attack", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "mouthController", state -> PlayState.STOP).triggerableAnim("mouth", RawAnimation.begin().then("anim.distortus_rex.mouth", Animation.LoopType.PLAY_ONCE)));
    }

    private float getSignedTurnDelta() {
        return Mth.wrapDegrees((float)(this.yBodyRot - this.yBodyRotO));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.mouthAnimCooldown > 0) {
                --this.mouthAnimCooldown;
            } else {
                this.triggerAnim("mouthController", "mouth");
                this.mouthAnimCooldown = this.random.nextInt(601) + 600;
            }
        }
        if (this.level().isClientSide) {
            this.tailSwayPrev = this.tailSwayOffset;
            this.updateProceduralTailSway();
        }
    }

    private void updateProceduralTailSway() {
        float turnDegrees = this.getSignedTurnDelta();
        float deadzoneDeg = 0.6f;
        float turnInput = 0.0f;
        if (Math.abs(turnDegrees) >= deadzoneDeg) {
            turnInput = Mth.clamp((float)(turnDegrees / 15.0f), (float)-1.0f, (float)1.0f);
        }
        float target = turnInput;
        float alpha = 0.24f;
        this.tailSwayOffset += (target - this.tailSwayOffset) * alpha;
        if (Math.abs(this.tailSwayOffset) < 0.003f) {
            this.tailSwayOffset = 0.0f;
        }
        this.tailSwayVelocity = 0.0f;
        this.tailSwayOffset = Mth.clamp((float)this.tailSwayOffset, (float)-1.5f, (float)1.5f);
    }

    public float getTailSwayOffset() {
        return this.tailSwayOffset;
    }

    public float getTailSwayOffset(float partialTick) {
        return Mth.lerp((float)Mth.clamp((float)partialTick, (float)0.0f, (float)1.0f), (float)this.tailSwayPrev, (float)this.tailSwayOffset);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(VARIANT, (Object)0);
    }

    public int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public DistortusRexVariant getVariant() {
        return DistortusRexVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(DistortusRexVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean canMate(Animal other) {
        if (!super.canMate(other)) {
            return false;
        }
        if (!(other instanceof DistortusRexEntity)) {
            return false;
        }
        DistortusRexEntity that = (DistortusRexEntity)other;
        return this.getVariant() != that.getVariant();
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(VARIANT, (Object)pCompound.getInt("Variant"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        DistortusRexVariant variant = (DistortusRexVariant)((Object)Util.getRandom((Object[])DistortusRexVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

