/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.cmr.jurassicrevived.recipe.DNAHybridizerRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record DNAHybridizerRecipe(NonNullList<Ingredient> inputs, ItemStack output) implements Recipe<DNAHybridizerRecipeInput>
{
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.DNA_HYBRIDIZER_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.DNA_HYBRIDIZER_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean matches(@NotNull DNAHybridizerRecipeInput recipeInput, Level level) {
        if (level.isClientSide) {
            return false;
        }
        if (recipeInput.size() != 3 || this.inputs.size() != 3) {
            return false;
        }
        return ((Ingredient)this.inputs.get(0)).test(recipeInput.getItem(0)) && ((Ingredient)this.inputs.get(1)).test(recipeInput.getItem(1)) && ((Ingredient)this.inputs.get(2)).test(recipeInput.getItem(2));
    }

    @NotNull
    public ItemStack assemble(@NotNull DNAHybridizerRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public static class Serializer
    implements RecipeSerializer<DNAHybridizerRecipe> {
        public static final MapCodec<DNAHybridizerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            if (list.size() != 3) {
                return DataResult.error(() -> "DNAHybridizerRecipe requires exactly 3 ingredients, got " + list.size());
            }
            NonNullList nnl = NonNullList.create();
            nnl.addAll((Collection)list);
            return DataResult.success((Object)nnl);
        }, nnl -> DataResult.success(List.copyOf(nnl))).forGetter(DNAHybridizerRecipe::inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(DNAHybridizerRecipe::output)).apply((Applicative)instance, DNAHybridizerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DNAHybridizerRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode(buf, recipe.inputs());
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output());
        }, buf -> {
            NonNullList decodedInputs = (NonNullList)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode(buf);
            if (decodedInputs.size() != 3) {
                throw new IllegalArgumentException("DNAHybridizerRecipe requires exactly 3 ingredients in stream, got " + decodedInputs.size());
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            return new DNAHybridizerRecipe((NonNullList<Ingredient>)decodedInputs, result);
        });

        @NotNull
        public MapCodec<DNAHybridizerRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DNAHybridizerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

