/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.cmr.jurassicrevived.recipe.EmbryonicMachineRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record EmbryonicMachineRecipe(NonNullList<Ingredient> inputs, ItemStack output, Map<ResourceLocation, Integer> weights) implements Recipe<EmbryonicMachineRecipeInput>
{
    public EmbryonicMachineRecipe(Ingredient first, Ingredient second, ItemStack output) {
        this((NonNullList<Ingredient>)NonNullList.create(), output, Map.of());
        this.inputs.add((Object)first);
        this.inputs.add((Object)second);
    }

    public EmbryonicMachineRecipe(NonNullList<Ingredient> inputs, ItemStack output) {
        this(inputs, output, Map.of());
    }

    public EmbryonicMachineRecipe(NonNullList<Ingredient> inputs, ItemStack output, Map<ResourceLocation, Integer> weights) {
        this.inputs = inputs;
        this.output = output;
        this.weights = Map.copyOf(weights);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.EMBRYONIC_MACHINE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.EMBRYONIC_MACHINE_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean matches(@NotNull EmbryonicMachineRecipeInput recipeInput, Level level) {
        if (level.isClientSide) {
            return false;
        }
        if (recipeInput.size() < 2 || this.inputs.size() < 2) {
            return false;
        }
        ItemStack in0 = recipeInput.getItem(0);
        ItemStack in1 = recipeInput.getItem(1);
        Ingredient a = (Ingredient)this.inputs.get(0);
        Ingredient b = (Ingredient)this.inputs.get(1);
        return a.test(in0) && b.test(in1) || a.test(in1) && b.test(in0);
    }

    @NotNull
    public ItemStack assemble(@NotNull EmbryonicMachineRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public int getWeightFor(Item item) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
        if (key == null) {
            return 1;
        }
        return Math.max(0, this.weights.getOrDefault(key, 1));
    }

    public static class Serializer
    implements RecipeSerializer<EmbryonicMachineRecipe> {
        private static final Codec<Map<ResourceLocation, Integer>> WEIGHTS_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT);
        public static final MapCodec<EmbryonicMachineRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            if (list.size() != 2) {
                return DataResult.error(() -> "EmbryonicMachineRecipe requires exactly 2 ingredients, got " + list.size());
            }
            NonNullList nnl = NonNullList.create();
            nnl.addAll((Collection)list);
            return DataResult.success((Object)nnl);
        }, nnl -> DataResult.success(List.copyOf(nnl))).forGetter(EmbryonicMachineRecipe::inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(EmbryonicMachineRecipe::output), (App)WEIGHTS_CODEC.optionalFieldOf("weights", Map.of()).forGetter(EmbryonicMachineRecipe::weights)).apply((Applicative)instance, EmbryonicMachineRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EmbryonicMachineRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode(buf, recipe.inputs());
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output());
            Map<ResourceLocation, Integer> weights = recipe.weights();
            buf.writeVarInt(weights.size());
            for (Map.Entry<ResourceLocation, Integer> e : weights.entrySet()) {
                buf.writeResourceLocation(e.getKey());
                buf.writeVarInt(e.getValue().intValue());
            }
        }, buf -> {
            NonNullList decodedInputs = (NonNullList)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode(buf);
            if (decodedInputs.size() != 2) {
                throw new IllegalArgumentException("EmbryonicMachineRecipe requires exactly 2 ingredients in stream, got " + decodedInputs.size());
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            int size = buf.readVarInt();
            HashMap<ResourceLocation, Integer> weights = new HashMap<ResourceLocation, Integer>();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buf.readResourceLocation();
                int w = buf.readVarInt();
                weights.put(id, w);
            }
            return new EmbryonicMachineRecipe((NonNullList<Ingredient>)decodedInputs, result, weights);
        });

        @NotNull
        public MapCodec<EmbryonicMachineRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, EmbryonicMachineRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

