/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.recipe;

import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public record EmbryonicMachineRecipeInput(List<ItemStack> inputs) implements RecipeInput
{
    public EmbryonicMachineRecipeInput {
        Objects.requireNonNull(inputs, "inputs");
        if (inputs.size() != 2) {
            throw new IllegalArgumentException("EmbryonicMachineRecipeInput requires exactly 2 input stacks, got " + inputs.size());
        }
        ItemStack first = Objects.requireNonNullElse(inputs.get(0), ItemStack.EMPTY);
        ItemStack second = Objects.requireNonNullElse(inputs.get(1), ItemStack.EMPTY);
        inputs = List.of(first, second);
    }

    public EmbryonicMachineRecipeInput(ItemStack first, ItemStack second) {
        this(List.of(first, second));
    }

    public ItemStack getItem(int i) {
        return this.inputs.get(i);
    }

    public int size() {
        return this.inputs.size();
    }
}

