/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.cmr.jurassicrevived.recipe.IncubatorRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record IncubatorRecipe(NonNullList<Ingredient> inputs, ItemStack output) implements Recipe<IncubatorRecipeInput>
{
    public IncubatorRecipe(Ingredient input, ItemStack output) {
        this((NonNullList<Ingredient>)NonNullList.create(), output);
        this.inputs.add((Object)input);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.INCUBATOR_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.INCUBATOR_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean matches(@NotNull IncubatorRecipeInput recipeInput, Level level) {
        if (level.isClientSide) {
            return false;
        }
        if (recipeInput.size() < 1 || this.inputs.size() < 1) {
            return false;
        }
        ItemStack in0 = recipeInput.getItem(0);
        Ingredient a = (Ingredient)this.inputs.get(0);
        return a.test(in0);
    }

    @NotNull
    public ItemStack assemble(@NotNull IncubatorRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public static class Serializer
    implements RecipeSerializer<IncubatorRecipe> {
        public static final MapCodec<IncubatorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            if (list.size() != 1) {
                return DataResult.error(() -> "IncubatorRecipe requires exactly 1 ingredient, got " + list.size());
            }
            NonNullList nnl = NonNullList.create();
            nnl.addAll((Collection)list);
            return DataResult.success((Object)nnl);
        }, nnl -> DataResult.success(List.copyOf(nnl))).forGetter(IncubatorRecipe::inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(IncubatorRecipe::output)).apply((Applicative)instance, IncubatorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, IncubatorRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode(buf, recipe.inputs());
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output());
        }, buf -> {
            NonNullList decodedInputs = (NonNullList)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode(buf);
            if (decodedInputs.size() != 1) {
                throw new IllegalArgumentException("IncubatorRecipe requires exactly 1 ingredient in stream, got " + decodedInputs.size());
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            return new IncubatorRecipe((NonNullList<Ingredient>)decodedInputs, result);
        });

        @NotNull
        public MapCodec<IncubatorRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, IncubatorRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

