/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.screen.custom;

import net.cmr.jurassicrevived.block.entity.custom.EmbryonicMachineBlockEntity;
import net.cmr.jurassicrevived.item.ModItems;
import net.cmr.jurassicrevived.screen.ModMenuTypes;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class EmbryonicMachineMenu
extends AbstractContainerMenu {
    public final EmbryonicMachineBlockEntity blockEntity;
    public final Level level;
    public final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 5;

    public EmbryonicMachineMenu(int containerId, Inventory inventory, FriendlyByteBuf data) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(data.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public EmbryonicMachineMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.EMBRYONIC_MACHINE_MENU.get(), containerId);
        this.blockEntity = (EmbryonicMachineBlockEntity)entity;
        this.level = inventory.player.level();
        this.data = data;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 0, 39, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == ModItems.SYRINGE.get();
            }

            public boolean mayPickup(Player playerIn) {
                return true;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 1, 57, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.DNA);
            }

            public boolean mayPickup(Player playerIn) {
                return true;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 2, 103, 35){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 3, 121, 35){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 4, 139, 35){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledArrowProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int arrowPixelSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * arrowPixelSize / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            int teInputStart = 36;
            int teInputEndExclusive = 38;
            if (!this.moveItemStackTo(sourceStack, teInputStart, teInputEndExclusive, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 41) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return EmbryonicMachineMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)this.blockEntity.getBlockState().getBlock());
    }

    public void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    public void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

