/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtterralith;

import com.ferreusveritas.dynamictrees.api.GatherDataHelper;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.nio.file.Path;
import maxhyper.dtterralith.DTTConfigs;
import maxhyper.dtterralith.registry.DTTRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.PathPackResources;

@Mod(value="dtterralith")
public class DynamicTreesTerralith {
    public static final String MOD_ID = "dtterralith";

    public DynamicTreesTerralith() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DTTConfigs.GENERAL_SPEC, "dtterralithconfig.toml");
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::setupBuiltInDatapack);
        MinecraftForge.EVENT_BUS.register((Object)this);
        RegistryHandler.setup((String)MOD_ID);
        DTTRegistries.setup();
    }

    private void gatherData(GatherDataEvent event) {
        GatherDataHelper.gatherAllData((String)MOD_ID, (GatherDataEvent)event, (Registry[])new Registry[]{Family.REGISTRY, Species.REGISTRY, LeavesProperties.REGISTRY});
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    private void setupBuiltInDatapack(AddPackFindersEvent event) {
        Pack pack;
        Path resourcePath;
        String MODID = MOD_ID;
        if (event.getPackType() == PackType.SERVER_DATA && ((Boolean)DTTConfigs.REPLACE_TREE_FEATURES_FIX.get()).booleanValue()) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"resourcepacks/replace_tree_features_fix"});
            pack = Pack.m_245429_((String)"builtin/replace_tree_features_fix", (Component)Component.m_237113_((String)"dtterralith fixes: replace_tree_features_fix"), (boolean)false, path -> new PathPackResources(path, false, resourcePath), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
        if (event.getPackType() == PackType.SERVER_DATA && ((Boolean)DTTConfigs.SKYLANDS_WINTER_FIX.get()).booleanValue()) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"resourcepacks/skylands_winter_fix"});
            pack = Pack.m_245429_((String)"builtin/skylands_winter_fix", (Component)Component.m_237113_((String)"dtterralith fixes: skylands_winter_fix"), (boolean)false, path -> new PathPackResources(path, false, resourcePath), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }
}

