/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtterralith.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.DenuderNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RandomStrippedBranches
extends GenFeature {
    public RandomStrippedBranches(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{PLACE_CHANCE});
    }

    @NotNull
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(PLACE_CHANCE, (Object)Float.valueOf(0.2f));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos rootPos;
        if (!context.species().getFamily().hasStrippedBranch()) {
            return false;
        }
        LevelAccessor level = context.level();
        RootyBlock dirt = TreeHelper.getRooty((BlockState)level.m_8055_(rootPos = context.pos()));
        if (dirt == null) {
            return false;
        }
        final Family family = context.species().getFamily();
        final float chance = ((Float)configuration.get(PLACE_CHANCE)).floatValue();
        if (!level.m_5776_()) {
            dirt.startAnalysis(level, rootPos, new MapSignal(new NodeInspector[]{new DenuderNode(context.species(), context.species().getFamily()){

                public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
                    if (level.m_213780_().m_188501_() >= chance) {
                        return false;
                    }
                    BranchBlock branch = TreeHelper.getBranch((BlockState)state);
                    if (branch == null || family.getBranch().map(other -> branch != other).orElse(false).booleanValue()) {
                        return false;
                    }
                    branch.stripBranch(state, level, pos, branch.getRadius(state));
                    return true;
                }
            }}));
        }
        return true;
    }
}

