/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtterralith.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class TallDeciduousLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> TRUNK_UP_BOOST = ConfigurationProperty.integer((String)"trunk_up_boost");

    public TallDeciduousLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(TRUNK_UP_BOOST, (Object)5);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{TRUNK_UP_BOOST});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        if (context.signal().isInTrunk()) {
            int n = Direction.UP.ordinal();
            probMap[n] = probMap[n] + (Integer)configuration.get(TRUNK_UP_BOOST);
        } else if (this.justTurnedOutOfTrunk(context.signal())) {
            probMap[Direction.UP.ordinal()] = 0;
        }
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.level(), context.pos());
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) * context.species().biomeSuitability(context.level(), context.pos()));
    }

    private boolean justTurnedOutOfTrunk(GrowSignal signal) {
        return signal.numTurns == 1 && (Math.abs(signal.delta.m_123341_()) == 1 || Math.abs(signal.delta.m_123343_()) == 1);
    }
}

