package wintermourn.wintersappend.block;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.config.AppendFuelsConfig;
import wintermourn.wintersappend.effects.MinorEffects;
import wintermourn.wintersappend.item.AppendItems;

public class AppendBlocks {
    public static final class_2960 TONIC_STAND_ID = new class_2960(WintersAppend.MOD_ID, "tonic_stand");
    public static final BlockItemPair TONIC_STAND;

    public static final class_2960 GYPSOPHILA_ID = new class_2960(WintersAppend.MOD_ID, "gypsophila");
    public static final BlockItemPair GYPSOPHILA;
    public static final class_2248 GYPSOPHILA_POTTED;

    static
    {
        TONIC_STAND = BlockItemPair.fromBlock(
                new TonicStandBlock(FabricBlockSettings.copyOf(class_2246.field_10333)),
                new class_1792.class_1793()
        );
        GYPSOPHILA = BlockItemPair.fromBlock(new FertilizableFlowerBlock(MinorEffects.SPEED, 20*30,0.08, FabricBlockSettings.method_9630(class_2246.field_10182))
                .addAlternateChance(AppendItems.SOUL_MEAL, 0.3));
        GYPSOPHILA_POTTED = new class_2362(GYPSOPHILA.getBlock(), FabricBlockSettings.method_9630(class_2246.field_10162));
    }

    static void register(class_2960 id, BlockItemPair block)
    {
        class_2378.method_10230(class_7923.field_41175, id, block.getBlock());
        class_2378.method_10230(class_7923.field_41178, id, block.getItem());
    }
    static void register(class_2960 id, class_2248 block)
    {
        class_2378.method_10230(class_7923.field_41175, id, block);
    }

    public static void Register()
    {
        register(TONIC_STAND_ID, TONIC_STAND);
        register(GYPSOPHILA_ID, GYPSOPHILA);
        AppendFuelsConfig.RegisteredFuels.put(GYPSOPHILA_ID, new class_3545<>(0, 60));
        register(new class_2960(WintersAppend.MOD_ID, "potted_gypsophila"), GYPSOPHILA_POTTED);
    }

    public static void addTabEntries(class_1761.class_7704 entries) {
        entries.method_45421(TONIC_STAND.getItem());
        entries.method_45421(GYPSOPHILA.getItem());
    }
}
