package wintermourn.wintersappend.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class FertilizableFlowerBlock extends class_2356 implements class_2256, VariablyFertilizable {
    double growChance = 0;
    Map<class_1792, Double> alternateChances = new HashMap<>();
    public FertilizableFlowerBlock(class_1291 suspiciousStewEffect, int effectDuration, double growChance, class_2251 settings) {
        super(suspiciousStewEffect, effectDuration, settings);
        this.growChance = growChance;
    }

    public FertilizableFlowerBlock addAlternateChance(class_1792 item, Double chance)
    {
        alternateChances.put(item, chance);
        return this;
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state, boolean isClient) {
        return world.method_8311(pos);
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return world.method_8311(pos);
    }

    @Override
    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        if (world.field_9229.method_43058() < this.growChance)
        {
            method_9577(world, pos, new class_1799(this));
        }
    }

    @Override
    public void growWithItem(class_3218 world, class_5819 random, class_2338 pos, class_2680 state, class_1799 item) {
        double currentChance = this.growChance;

        if (alternateChances.containsKey(item.method_7909()))
        {
            currentChance = alternateChances.get(item.method_7909());
        }

        if (world.field_9229.method_43058() < currentChance)
        {
            method_9577(world, pos, new class_1799(this));
        }
    }
}
