package wintermourn.wintersappend.block.entity;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import wintermourn.wintersappend.config.AppendFuelsConfig;
import wintermourn.wintersappend.item.TonicUtil;
import wintermourn.wintersappend.networking.AppendMessages;
import wintermourn.wintersappend.recipe.CatalystRecipe;
import wintermourn.wintersappend.recipe.TonicBrewingRecipe;
import wintermourn.wintersappend.recipe.TonicStandRecipe;
import wintermourn.wintersappend.screen.TonicStandScreenHandler;
import wintermourn.wintersappend.config.AppendServerConfig;

import java.util.Optional;

public class TonicStandBlockEntity extends class_2586 implements ExtendedScreenHandlerFactory, class_1278 {
    public static final int MAX_FUEL = 100;
    public static final int MAX_PURITY = 120;
    public static final int OUTPUT_SLOT_ID = 0;
    public static final int FUEL_SLOT_ID = 4;
    public static final int PURITY_SLOT_ID = 5;

    float fuelEfficiency = 1;
    float purityEfficiency = 1;
    float timeEfficiency = 1;

    class_2371<class_1799> inventory;
    class_3913 propertyDelegate;

    boolean amIDirty = false;
    int brewTime = 0;
    int fuel = 0;
    int purity = 0;
    int fuelPartialTicks = 0;
    int purityPartialTicks = 0;

    int brewingMode = 0;
    // 0 = tonic, 1 = catalyst

    TonicStandRecipe recipe;
    public TonicStandBlockEntity(class_2338 pos, class_2680 state) {
        super(AppendBlockEntities.TONIC_STAND_BLOCK_ENTITY, pos, state);
        this.inventory = class_2371.method_10213(6, class_1799.field_8037);
        this.propertyDelegate = new class_3913() {
            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> TonicStandBlockEntity.this.brewTime;
                    case 1 -> TonicStandBlockEntity.this.fuel;
                    case 2 -> TonicStandBlockEntity.this.purity;
                    case 3 -> TonicStandBlockEntity.this.getFuelEstimate();
                    case 4 -> TonicStandBlockEntity.this.getMaxBrewTime();
                    case 5 -> TonicStandBlockEntity.this.getPurityEstimate();
                    case 6 -> TonicStandBlockEntity.this.brewingMode;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0 -> TonicStandBlockEntity.this.brewTime = value;
                    case 1 -> TonicStandBlockEntity.this.fuel = value;
                    case 2 -> TonicStandBlockEntity.this.purity = value;
                    case 6 -> TonicStandBlockEntity.this.brewingMode = value;
                }

            }

            public int method_17389() {
                return 7;
            }
        };
    }

    public static TonicStandBlockEntity withEfficiency(class_2338 pos, class_2680 state, float fuel, float purity, float time)
    {
        TonicStandBlockEntity entity = new TonicStandBlockEntity(pos, state);
        entity.fuelEfficiency = fuel;
        entity.purityEfficiency = purity;
        entity.timeEfficiency = time;

        return entity;
    }

    public void setEfficiency(float fuel, float purity, float time)
    {
        this.fuelEfficiency = fuel;
        this.purityEfficiency = purity;
        this.timeEfficiency = time;
    }

    public float getPurityEfficiency() {
        return 1;
    }

    public int getMaxPurity() {
        return TonicStandBlockEntity.MAX_PURITY;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    @Override
    public boolean method_5442() {
        return inventory.isEmpty();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return inventory.get(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(inventory, slot, amount);
        if (!result.method_7960())
        {
            amIDirty = true;
            method_5431();
        }
        return result;
    }

    @Override
    public class_1799 method_5441(int slot) {
        class_1799 slotItem = inventory.get(slot);
        inventory.set(slot, class_1799.field_8037);
        amIDirty = true;
        method_5431();
        return slotItem;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        inventory.set(slot, stack);
        if (stack.method_7947() > method_5444()) {
            stack.method_7939(method_5444());
        }
        amIDirty = true;
        method_5431();
//        if (inventory.get(slot).isEmpty())
//        {
//            inventory.set(slot, stack);
//        }
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105(this, player);
    }

    @Override
    public void method_5448() {
        inventory.clear();
    }

    protected class_1703 createScreenHandler(int syncId, class_1661 playerInventory) {
        return new TonicStandScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return new TonicStandScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TonicStandBlockEntity me)
    {
        if (world.method_8608()) return;

        if (me.isOutputValid())
        {
            if (me.hasRecipe())
            {
                me.increaseCraftProgress();
                method_31663(world, pos, state);

                if (me.isCraftingFinished())
                {
                    me.craftItem();
                    me.resetProgress();
                    method_31663(world, pos, state);
                }
            } else
            {
                if (me.decreaseCraftProgress())
                    me.amIDirty = true;
            }
        } else
        {
            if (me.decreaseCraftProgress())
                me.amIDirty = true;
        }

        if (me.amIDirty)
            method_31663(world, pos, state);

        class_1799 fuelStack = me.inventory.get(TonicStandBlockEntity.FUEL_SLOT_ID);
        if (!fuelStack.method_7960())
        {
            int value = AppendFuelsConfig.GetHeatFuel(fuelStack);
            if (value > -1 && me.fuel <= me.getMaxFuel() - value)
            {
                me.fuel += value;
                fuelStack.method_7934(1);
            }
        }

        class_1799 purityStack = me.inventory.get(TonicStandBlockEntity.PURITY_SLOT_ID);
        if (!purityStack.method_7960())
        {
            int value = AppendFuelsConfig.GetPurity(purityStack);
            if (value > -1 && me.purity <= me.getMaxPurity() - value)
            {
                me.purity += value;
                purityStack.method_7934(1);
            }
        }
    }

    public static void method_31663(class_1937 world, class_2338 pos, class_2680 myState) {
        if (world.method_8321(pos) instanceof TonicStandBlockEntity me)
        {
            me.method_5431();
//            if (me.inventory.get(OUTPUT_SLOT_ID).isEmpty() && myState.get(TonicStandBlock.HAS_BOTTLE))
//            {
//                world.setBlockState(pos, myState.with(TonicStandBlock.HAS_BOTTLE, false));
//            } else if (!me.inventory.get(OUTPUT_SLOT_ID).isEmpty() && !myState.get(TonicStandBlock.HAS_BOTTLE))
//            {
//                world.setBlockState(pos, myState.with(TonicStandBlock.HAS_BOTTLE, true));
//            }
        }
    }


    private boolean decreaseCraftProgress() {
        if (brewTime > 1)
        {
            brewTime -= 2;
            return true;
        } else if (brewTime > 0)
        {
            brewTime--;
            return true;
        }
        return false;
    }

    private void resetProgress() {
        brewTime = 0;
    }

    private void craftItem() {
        class_1799 outputStack = inventory.get(TonicStandBlockEntity.OUTPUT_SLOT_ID);

        inventory.set(TonicStandBlockEntity.OUTPUT_SLOT_ID, this.recipe.craft(this, null));

        inventory.get(1).method_7934(1);
        inventory.get(2).method_7934(1);
        inventory.get(3).method_7934(1);

        if (!AppendServerConfig.spendFuelDuringBrew)
        {
            boolean hasPurity = this.getPurity() > this.recipe.purityCost / this.getPurityEfficiency();
            fuel -= (int) (Math.round(this.recipe.fuelCost / this.fuelEfficiency) * (hasPurity ? 1 : AppendServerConfig.impureFuelPenalty));
            purity -= Math.round(this.recipe.purityCost / this.getPurityEfficiency());
            if (fuel < 0) fuel = 0;
            if (purity < 0) purity = 0;
        }

        if (this.field_11863 != null && !this.field_11863.field_9236)
        {
            for (class_1657 player : this.field_11863.method_18456()) {
                ServerPlayNetworking.send(
                        (class_3222) player,
                        AppendMessages.BREWING_FINISHED,
                        PacketByteBufs.create().method_10807(this.field_11867).method_10793(inventory.get(OUTPUT_SLOT_ID)));
            }
        }
    }

    private boolean isCraftingFinished() {
        return (hasRecipe() && getMaxBrewTime() <= this.brewTime);
    }

    private void increaseCraftProgress() {
        brewTime++;

        if (AppendServerConfig.spendFuelDuringBrew)
        {
            float fuelPrice = (recipe.fuelCost / (recipe.brewingTime * this.timeEfficiency * ((purity > 0) ? 1 : AppendServerConfig.impureTimePenalty)))
                    * this.fuelEfficiency * (fuelPartialTicks + 1)
                    * ((purity > 0) ? 1 : AppendServerConfig.impureFuelPenalty);
            float purityPrice = (recipe.purityCost / (recipe.brewingTime * this.timeEfficiency * ((purity > 0) ? 1 : AppendServerConfig.impureTimePenalty)))
                    * this.purityEfficiency * (purityPartialTicks + 1);
            if (fuelPrice < 1) fuelPartialTicks++; else
            {
                fuel -= (int) fuelPrice;
                fuelPartialTicks = 0;
            }
            if (purityPrice < 1) purityPartialTicks++; else
            {
                purity -= (int) purityPrice;
                purityPartialTicks = 0;
            }
        }
    }

    boolean hasRecipe() {
        if (method_10997() == null) return false;
        Optional<?> recipe = switch (brewingMode) {
            case 0 -> method_10997().method_8433().method_8132(TonicBrewingRecipe.Type.INSTANCE, this, field_11863);
            case 1 -> method_10997().method_8433().method_8132(CatalystRecipe.Type.INSTANCE, this, field_11863);
            default -> Optional.empty();
        };

        this.recipe = (TonicStandRecipe) recipe.orElse(null);

        return this.recipe != null;
    }

    boolean isOutputValid()
    {
        class_1799 stack = inventory.get(0);
        return recipe != null && recipe.isOutputValid(stack);
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);

        nbt.method_10569("fuel",fuel);
        if (fuelPartialTicks > 0) nbt.method_10569("fuelP",fuelPartialTicks);
        nbt.method_10569("brewTime",brewTime);
        nbt.method_10569("purity",purity);
        if (purityPartialTicks > 0) nbt.method_10569("purityP",purityPartialTicks);
        nbt.method_10569("brewingMode", brewingMode);

        class_2499 stacks = new class_2499();

        for (class_1799 stack : inventory) {
            class_2487 item = new class_2487();
            stack.method_7953(item);
            stacks.add(item);
        }

        nbt.method_10566("contents", stacks);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);

        fuel = nbt.method_10550("fuel");
        fuelPartialTicks = nbt.method_10550("fuelP");
        brewTime = nbt.method_10550("brewTime");
        purity = nbt.method_10550("purity");
        purityPartialTicks = nbt.method_10550("purityP");
        brewingMode = nbt.method_10550("brewingMode");

        class_2499 stacks = nbt.method_10554("contents", class_2520.field_33260);

        for (int i = 0; i < stacks.size(); i++) {
            if (stacks.method_10534(i) instanceof class_2487 compound)
            {
                class_1799 stack = class_1799.method_7915(compound);
                inventory.set(i, stack != null ? stack : class_1799.field_8037);
            }
        }
    }

    public int getFuel() {
        return this.fuel;
    }
    public int getMaxFuel() {
        return TonicStandBlockEntity.MAX_FUEL;
    }
    public int getBrewTime() {
        return this.brewTime;
    }
    public int getMaxBrewTime() {
        if (this.hasRecipe())
        {
            boolean hasPurity = this.getPurity() > this.recipe.purityCost / this.getPurityEfficiency();
            return Math.round(this.recipe.brewingTime * (hasPurity ? 1 : AppendServerConfig.impureTimePenalty));
        } else
        {
            return 9999;
        }
    }
    public float getBrewPercent() { return getBrewTime()/(float)getMaxBrewTime(); }

    @Nullable
    public Integer getFluidColor()
    {
        if (inventory.get(OUTPUT_SLOT_ID).method_7960()) return null;
        return TonicUtil.getColor(inventory.get(OUTPUT_SLOT_ID));
    }

    public int[] getFluidColorRGB()
    {
        if (inventory.get(OUTPUT_SLOT_ID).method_7960()) return new int[]{0,0,0};
        return TonicUtil.getColorRGB(inventory.get(OUTPUT_SLOT_ID));
    }

    public void setOutputStack(class_1799 stack)
    {
        inventory.set(OUTPUT_SLOT_ID, stack);
    }

    public int getBrewingMode()
    {
        return brewingMode;
    }

    public void setBrewingMode(int mode)
    {
        this.brewingMode = mode;
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(field_11867);
    }

    public int getFuelEstimate() {
        if (this.hasRecipe())
        {
            boolean hasPurity = this.getPurity() > this.recipe.purityCost / this.getPurityEfficiency();

            if (AppendServerConfig.spendFuelDuringBrew)
                return this.fuel - (int)Math.ceil(this.recipe.fuelCost / this.fuelEfficiency * (hasPurity ? 1 : AppendServerConfig.impureFuelPenalty) * (1-getBrewPercent()));
            else
                return this.fuel - Math.round(this.recipe.fuelCost / this.fuelEfficiency * (hasPurity ? 1 : AppendServerConfig.impureFuelPenalty));
        } else return this.getFuel();
    }

    private int getPurityEstimate() {
        if (this.hasRecipe())
        {
            if (AppendServerConfig.spendFuelDuringBrew)
                return this.purity - (int)Math.ceil(this.recipe.purityCost / this.getPurityEfficiency() * (1-getBrewPercent()));
            else
                return this.purity - Math.round(this.recipe.purityCost / this.getPurityEfficiency());
        } else return this.getPurity();
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("block.winters_append.tonic_stand");
    }

    public int getPurity() {
        return purity;
    }

    public boolean hasOutput() {
        return !this.inventory.get(OUTPUT_SLOT_ID).method_7960();
    }
}
