package wintermourn.wintersappend.callbacks;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_6860;
import net.minecraft.server.MinecraftServer;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.config.AppendFuelsConfig;
import wintermourn.wintersappend.networking.AppendMessages;
import wintermourn.wintersappend.config.AppendServerConfig;
import wintermourn.wintersappend.config.AppendServerUserConfig;

import java.util.Objects;

public class ServerDataReloadFinished implements ServerLifecycleEvents.EndDataPackReload {
    @Override
    public void endDataPackReload(MinecraftServer server, class_6860 resourceManager, boolean success) {
        if (success)
        {
            WintersAppend.LOGGER.info("Reloading mod server config...");
            AppendServerUserConfig.HANDLER.load();
            AppendServerConfig.CopyUserConfig();
            WintersAppend.LOGGER.info("Reloading mod fuel config...");
            AppendFuelsConfig.LoadConfig();

            class_2540 buf = AppendServerConfig.CreateConfigBuf();
            class_2540 fuels = AppendFuelsConfig.CreateFuelsPacket();
            for (class_3222 player : Objects.requireNonNull(server.method_3760().method_14571())) {
                ServerPlayNetworking.send(
                    player,
                    AppendMessages.RECEIVE_SERVER_CONFIG,
                    buf
                );
                ServerPlayNetworking.send(
                    player,
                    AppendMessages.SERVER_FUELS,
                    fuels
                );
            }
        }
    }
}
