package wintermourn.wintersappend.client;

import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import wintermourn.wintersappend.client.configGroups.TonicConfig;
import wintermourn.wintersappend.networking.AppendMessages;
import wintermourn.wintersappend.config.AppendClientConfig;
import wintermourn.wintersappend.config.AppendServerConfig;
import wintermourn.wintersappend.config.AppendServerUserConfig;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AppendConfigUI {
    public static class_2561 LABEL_SERVER = class_2561.method_43471("config.winters_append.label_server").method_27695(class_124.field_1075, class_124.field_1067, class_124.field_1056);
    public static class_2561 LABEL_CLIENT = class_2561.method_43471("config.winters_append.label_client").method_27695(class_124.field_1065, class_124.field_1067, class_124.field_1056);

    public static class_437 CreateScreen(class_437 parent)
    {
        return YetAnotherConfigLib.createBuilder()
                .title(class_2561.method_43471("winters_append.title"))
                .category(ConfigCategory.createBuilder()
                        .name(class_2561.method_43471("config.winters_append.tonics.title"))
                        .tooltip(class_2561.method_43471("config.winters_append.tonics.desc"))
                        .groups(List.of(TonicConfig.Tooltip, TonicConfig.Brewing, TonicConfig.Effects))
                        .build()
                )
                .save(()-> {
                    AppendServerUserConfig.HANDLER.save();

                    if (class_310.method_1551().method_47392())
                    {
                        AppendServerConfig.CopyUserConfig();

                        class_2540 buf = AppendServerConfig.CreateConfigBuf();
                        for (class_3222 player : Objects.requireNonNull(class_310.method_1551().method_1576()).method_3760().method_14571()) {
                            ServerPlayNetworking.send(
                                    player,
                                    AppendMessages.RECEIVE_SERVER_CONFIG,
                                    buf);
                        }
                    }

                    AppendClientConfig.HANDLER.save();
                })
                .build()
                .generateScreen(parent);
    }

    public static Controller<Integer> CreateIntSlider(Option<Integer> opt, int min, int max, int step, ValueFormatter<Integer> formatter)
    {
        return IntegerSliderControllerBuilder.create(opt).range(min, max).step(step)
                .formatValue(formatter).build();
    }

    public static Controller<Float> CreateFloatSlider(Option<Float> opt, float min, float max, float step, ValueFormatter<Float> formatter)
    {
        return FloatSliderControllerBuilder.create(opt).range(min, max).step(step)
                .formatValue(formatter).build();
    }


    public static <T> Option<T> CreateOption(String name, T def, Supplier<T> supplier, Consumer<T> consumer, Function<Option<T>, Controller<T>> controller)
    {
        return Option.<T>createBuilder()
                .name(class_2561.method_43471(name +".name"))
                .description(OptionDescription.of(class_2561.method_43471(name +".desc")))
                .binding(def, supplier, consumer)
                .customController(controller)
                .build();
    }

}
