package wintermourn.wintersappend.client.renderer.block;

import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import wintermourn.wintersappend.block.entity.TonicStandBlockEntity;

public class TonicStandRenderer implements class_827<TonicStandBlockEntity> {
    float PADDING = 4 / 16f;
    float VERTIPOS = 6 / 16f;

    public TonicStandRenderer(class_5614.class_5615 ctx) {
    }

    @Override
    public void render(TonicStandBlockEntity entity, float tickDelta, class_4587 matrices,
                       class_4597 vertexConsumers, int light, int overlay) {
        class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_23577());
        class_4587.class_4665 worldMatrix = matrices.method_23760();

        FluidRenderHandler renderHandler = FluidRenderHandlerRegistry.INSTANCE.get(class_3612.field_15910);
        class_1058[] sprites = renderHandler.getFluidSprites(null, null, class_3612.field_15910.method_15785());
        class_1058 waterSprite = sprites[0];
        int[] color = entity.getFluidColorRGB();

        matrices.method_22903();

        float texSizeU = waterSprite.method_4577() - waterSprite.method_4594();
        float texSizeV = waterSprite.method_4575() - waterSprite.method_4593();
        float texPaddingU = PADDING * texSizeU;
        float texPaddingV = PADDING * texSizeV;

        if (entity.hasOutput() && color != null)
        {
            consumer
                    .method_22918(worldMatrix.method_23761(), PADDING, VERTIPOS, 1f-PADDING)
                    .method_1336(color[0],color[1],color[2],0xaa)
                    .method_22913(waterSprite.method_4594() + texPaddingU, waterSprite.method_4593() + texPaddingV)
                    .method_22916(light)
                    .method_22914(0f,1f,0f)
                    .method_1344();
            consumer
                    .method_22918(worldMatrix.method_23761(), 1f-PADDING, VERTIPOS, 1f-PADDING)
                    .method_1336(color[0],color[1],color[2],0xaa)
                    .method_22913(waterSprite.method_4577() - texPaddingU, waterSprite.method_4593() + texPaddingV)
                    .method_22916(light)
                    .method_22914(0f,1f,0f)
                    .method_1344();
            consumer
                    .method_22918(worldMatrix.method_23761(), 1f-PADDING, VERTIPOS, PADDING)
                    .method_1336(color[0],color[1],color[2],0xaa)
                    .method_22913(waterSprite.method_4577() - texPaddingU, waterSprite.method_4575() - texPaddingV)
                    .method_22916(light)
                    .method_22914(0f,1f,0f)
                    .method_1344();
            consumer
                    .method_22918(worldMatrix.method_23761(), PADDING, VERTIPOS, PADDING)
                    .method_1336(color[0],color[1],color[2],0xaa)
                    .method_22913(waterSprite.method_4594() + texPaddingU, waterSprite.method_4575() - texPaddingV)
                    .method_22916(light)
                    .method_22914(0f,1f,0f)
                    .method_1344();

        }

        matrices.method_22909();

    }
}
