package wintermourn.wintersappend.config;

import com.google.gson.*;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import wintermourn.wintersappend.WintersAppend;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AppendFuelsConfig {
    public static final Path CONFIG_PATH = Paths.get("config/wintermourn/"+ WintersAppend.MOD_ID, "fuels.json");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    /** An automatically updated list of valid fuels for the Tonic Stand. Left is heat fuel, right is purity.
     * <br>Use RegisteredFuels if you're planning on adding your own items through code. */
    public static Map<class_2960, class_3545<Integer, Integer>> Fuels = new HashMap<>();
    /** A manual list of fuel types that are applied to missing entries in the user's config.<br>
     * Left in the pair is heat fuel, right is purity. */
    public static final Map<class_2960, class_3545<Integer, Integer>> RegisteredFuels = new HashMap<>();

    public static void LoadConfig()
    {
        try {
            if (Files.exists(CONFIG_PATH))
            {
                LoadValues();
            } else {
                Files.createDirectories(CONFIG_PATH.getParent());
                JsonObject defaultJsonObject = createDefaultConfig();
                saveConfig(defaultJsonObject);
                LoadValues();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static JsonObject GetConfig()
    {
        try {
            if (!Files.exists(CONFIG_PATH))
            {
                Files.createDirectories(CONFIG_PATH.getParent());
                JsonObject defaultJsonObject = createDefaultConfig();
                saveConfig(defaultJsonObject);
            }
            FileReader fileReader = new FileReader(CONFIG_PATH.toFile());
            return JsonParser.parseReader(fileReader).getAsJsonObject();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static void LoadValues()
    {
        try (FileReader fileReader = new FileReader(CONFIG_PATH.toFile()))
        {
            JsonObject jsonObject = JsonParser.parseReader(fileReader).getAsJsonObject();
            LoadValues(jsonObject);
        } catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    protected static void LoadValues(JsonObject jsonObject)
    {
        Fuels = new HashMap<>();

        try {
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet())
            {
                if (!entry.getValue().isJsonObject()) continue;
                JsonObject entryObject = entry.getValue().getAsJsonObject();

                int fuel = entryObject.has("fuel") ? entryObject.get("fuel").getAsInt() : -1;
                int purity = entryObject.has("purity") ? entryObject.get("purity").getAsInt() : -1;
                Fuels.put(class_2960.method_12829(entry.getKey()), new class_3545<>(fuel, purity));
            }
            for (Map.Entry<class_2960, class_3545<Integer, Integer>> entry : RegisteredFuels.entrySet())
            {
                if (Fuels.containsKey(entry.getKey())) continue;
                Fuels.put(entry.getKey(), entry.getValue());
            }
        } catch (Exception ignored) {}
    }

    private static JsonObject createDefaultConfig() {
        JsonObject defaultJsonObject = new JsonObject();
        JsonObject blazeDefault = new JsonObject();
        blazeDefault.addProperty("fuel", 100);
        JsonObject gypsoDefault = new JsonObject();
        gypsoDefault.addProperty("purity", 60);
        // Add default weights for known items
        defaultJsonObject.add("minecraft:blaze_powder", blazeDefault);
        defaultJsonObject.add( WintersAppend.MOD_ID+":gypsophila", gypsoDefault);
        return defaultJsonObject;
    }

    private static void saveConfig(JsonObject jsonObject) throws IOException {
        try (FileWriter fileWriter = new FileWriter(CONFIG_PATH.toFile())) {
            GSON.toJson(jsonObject, fileWriter);
        }
    }

    public static int GetHeatFuel(class_1799 stack)
    {
        class_2960 id = class_7923.field_41178.method_10221(stack.method_7909());
        if (Fuels.containsKey(id))
        {
            return Fuels.get(id).method_15442();
        }
        return -1;
    }

    public static int GetPurity(class_1799 stack)
    {
        class_2960 id = class_7923.field_41178.method_10221(stack.method_7909());
        if (Fuels.containsKey(id))
        {
            return Fuels.get(id).method_15441();
        }
        return -1;
    }

    // I don't like that I'm just sending the config file as JSON instead of sending a list of ID (string), type (byte), and value (int),
    // but I don't know how to check if it's done scanning the data, so...
    // If anyone's reading this that knows how to do this (or might know someone who does), please let me (Wintermourn) know.
    public static void TransferFuelsFromServer(class_2540 buf)
    {
        JsonObject config = JsonParser.parseString(buf.method_19772()).getAsJsonObject();
        LoadValues(config);
    }

    public static class_2540 CreateFuelsPacket()
    {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(Objects.requireNonNull(GetConfig()).toString());
        return buf;
    }

}
