package wintermourn.wintersappend.effects;

import com.demonwav.mcdev.annotations.Translatable;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1322;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.enums.DamageTypes;
import wintermourn.wintersappend.item.TonicUtil;

public class ImmunizationEffects {
    public static final class_1291 ANTIVENOM;
    public static final class_1291 DETHORNING;
    public static final class_1291 KINETIC_RESIST;
    public static final class_1291 PURITY;

    static
    {
        ANTIVENOM = new ImmunizationStatusEffect(class_4081.field_18271, 0xaaffaa)
                .addSources(class_1294.field_5899).method_5566(
                        class_5134.field_23721,
                        "5bcad147-0abc-4101-a93e-3becacfedf9e",
                        -0.1,
                        class_1322.class_1323.field_6331
                );

        DETHORNING = new DamageResistStatusEffect(class_4081.field_18271, 0xaaffaa)
                .addSources(DamageTypes.THORNS.toString(), DamageTypes.SWEET_BERRY.toString(), DamageTypes.CACTUS.toString())
                .setProtection(0.5).setAmplifierProtection(0.5).method_5566(
                        class_5134.field_23723,
                        "c84dc22b-b8ef-4e61-8829-961988cd9151",
                        -0.05,
                        class_1322.class_1323.field_6331
                ).method_5566(
                        class_5134.field_23719,
                        "cca22cf4-2eb7-454b-941a-71e6b43f0d87",
                        -0.05,
                        class_1322.class_1323.field_6331
                );

        KINETIC_RESIST = new DamageResistStatusEffect(class_4081.field_18271, 0xaaffaa)
                .addSources(DamageTypes.ELYTRA.toString(), DamageTypes.FALLING.toString())
                .setProtection(0.5).setAmplifierProtection(0.1).method_5566(
                        class_5134.field_23724,
                        "adf62d26-0cb1-4421-935a-af3d478c2ffb",
                        -0.10,
                        class_1322.class_1323.field_6331
                );

        PURITY = new PurityStatusEffect(class_4081.field_18271, 0x33ffff, class_4081.field_18272)
                .method_5566(
                        class_5134.field_23724,
                        "3d2e1b0c-954d-4017-ad20-8b63c34c4478",
                        -1,
                        class_1322.class_1323.field_6328
                );

    }

    public static void Register()
    {
        class_2378.method_10230(class_7923.field_41174, new class_2960(WintersAppend.MOD_ID, "immune/antivenom"), ANTIVENOM);
        class_2378.method_10230(class_7923.field_41174, new class_2960(WintersAppend.MOD_ID, "immune/thorns"), DETHORNING);
        class_2378.method_10230(class_7923.field_41174, new class_2960(WintersAppend.MOD_ID, "immune/kinetic"), KINETIC_RESIST);
        class_2378.method_10230(class_7923.field_41174, new class_2960(WintersAppend.MOD_ID, "immune/purity"), PURITY);

        TonicUtil.registerColor(ANTIVENOM, 0x38A8D8);
        TonicUtil.registerColor(DETHORNING, 0xF8A828);

        TonicUtil.registerText(ANTIVENOM, i -> class_2561.method_43471( "tonic.effect.antivenom" ));
        TonicUtil.registerText(DETHORNING, i -> ResistText( "tonic.effect.dethorn", (1-i) * 50 ));
        TonicUtil.registerText(KINETIC_RESIST, i -> ResistText( "tonic.effect.kinetic", (5-i) * 10 ));
        TonicUtil.registerText(PURITY, i -> class_2561.method_43469("tonic.effect.purity", i + 1));

        TonicUtil.registerName(ANTIVENOM, "tonic.name.antivenom");
        TonicUtil.registerName(DETHORNING, "tonic.name.dethorn");
        TonicUtil.registerName(KINETIC_RESIST, "tonic.name.kinetic");
        TonicUtil.registerName(PURITY, "tonic.name.purity");
    }

    static class_2561 ResistText(@Translatable String key, double value)
    {
        if (value > 0)
            return class_2561.method_43469(key, value);
        else
            return class_2561.method_43471(key+".full");
    }

}
