package wintermourn.wintersappend.effects;

import com.demonwav.mcdev.annotations.Translatable;
import net.minecraft.class_1291;
import net.minecraft.class_1322;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.item.TonicUtil;

public class MajorEffects {
    public static final class_1291 CONCEALED;
    public static final TemporaryEnchantEffect SILK_TOUCH;
    public static final TemporaryEnchantEffect FORTUNE;

    static
    {
        CONCEALED = new NormalStatusEffect(class_4081.field_18271, 0x999999).method_5566(
                class_5134.field_23717,
                "dc09df33-323b-48bc-b2b0-936d8ffe7e8d",
                -10,
                class_1322.class_1323.field_6328
        );
        SILK_TOUCH = new TemporaryEnchantEffect(class_4081.field_18271, 0x99FFDD);
        SILK_TOUCH.set(class_1893.field_9099, i -> i > 0 || WintersAppend.RANDOM.nextFloat() <= .8f);

        FORTUNE = new TemporaryEnchantEffect(class_4081.field_18271, 0x88ff88);
        FORTUNE.set(class_1893.field_9130, i -> WintersAppend.RANDOM.nextFloat() <= 1 / (1 + Math.exp(-1 * (i+1))));
    }

    public static void Register()
    {
        class_2378.method_10230(class_7923.field_41174, new class_2960(WintersAppend.MOD_ID, "major/concealed"), CONCEALED);
        TonicUtil.registerColor(CONCEALED, 0x999999);
        TonicUtil.registerText(CONCEALED, i -> class_2561.method_43471("tonic.effect.concealed"));
        TonicUtil.registerName(CONCEALED, "tonic.name.concealed");

        class_2378.method_10230(class_7923.field_41174, new class_2960(WintersAppend.MOD_ID, "major/silk_touch"), SILK_TOUCH);
        TonicUtil.registerColor(SILK_TOUCH, 0x99FFDD);
        TonicUtil.registerText(SILK_TOUCH, i -> VariableDescription( "tonic.effect.silk_touch", i ));
        TonicUtil.registerName(SILK_TOUCH, "tonic.name.silk_touch");

        class_2378.method_10230(class_7923.field_41174, new class_2960(WintersAppend.MOD_ID, "major/fortune"), FORTUNE);
        TonicUtil.registerColor(FORTUNE, 0x88ff88);
        TonicUtil.registerText(FORTUNE, i -> class_2561.method_43469( "tonic.effect.fortune", Math.round((1 / (1 + Math.exp(-1 * (i+1)))) * 1000) /10f ));
        TonicUtil.registerName(FORTUNE, "tonic.name.fortune");
    }

    static class_2561 VariableDescription(String key, int value)
    {
        return class_2561.method_43471(key + "." + value);
    }

    static class_2561 VariableText(@Translatable String key, double value)
    {
        return class_2561.method_43469(key, value);
    }
}
