package wintermourn.wintersappend.integration.emi.category;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiStack;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.block.AppendBlocks;
import wintermourn.wintersappend.category.AppendCreativeCategory;
import wintermourn.wintersappend.integration.emi.recipe.EmiTonicRecipe;
import wintermourn.wintersappend.item.AppendItems;
import wintermourn.wintersappend.item.TonicItem;
import wintermourn.wintersappend.item.TonicUtil;
import wintermourn.wintersappend.recipe.TonicBrewingRecipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class EmiTonicCategory {
    public static final class_2960 TEXTURE = new class_2960(WintersAppend.MOD_ID, "textures/gui/emi/tonic_icon.png");
    public static final EmiStack WORKSTATION = EmiStack.of(AppendBlocks.TONIC_STAND.getBlock());

    public static final Comparison TONIC_COMPARISON = Comparison.of((recipe, item) -> {
        if (!(recipe.getItemStack().method_7909() instanceof TonicItem) || !(item.getItemStack().method_7909() instanceof TonicItem)) return false;

        if (!recipe.hasNbt() || !item.hasNbt()) return false;

        class_2499 listA = recipe.getNbt().method_10554(TonicUtil.TONIC_EFFECTS_KEY, class_2520.field_33259);
        class_2499 listB = item.getNbt().method_10554(TonicUtil.TONIC_EFFECTS_KEY, class_2520.field_33259);
        List<String> stringsA = new ArrayList<>(listA.size());
        List<String> stringsB = new ArrayList<>(listB.size());
        for (class_2520 element : listA)
        {
            if (element instanceof class_2499 list)
            {
                String id = list.method_10608(0);
                if (id != null) stringsA.add(id);
            }
        }
        for (class_2520 element : listB)
        {
            if (element instanceof class_2499 list)
            {
                String id = list.method_10608(0);
                if (id != null) stringsB.add(id);
            }
        }

        if (stringsA.size() != stringsB.size()) return false;

        for (String entry : stringsA)
        {
            if (!stringsB.contains(entry)) return false;
        }return true;
    });
    public static final EmiRecipeCategory CATEGORY
            = new EmiRecipeCategory(
                    new class_2960(WintersAppend.MOD_ID, "tonic_stand"),
            WORKSTATION,
            new EmiTexture(TEXTURE, 0, 0, 16, 16)
    );

    public static void Register(EmiRegistry registry)
    {
        registry.addCategory(CATEGORY);

        registry.addWorkstation(CATEGORY, WORKSTATION);

        registry.setDefaultComparison(EmiStack.of(AppendItems.TONIC), TONIC_COMPARISON); //Comparison.compareNbt()

        class_1863 manager = registry.getRecipeManager();

        //registry.removeEmiStacks((stack) -> stack.getItemStack().getItem() == AppendItems.TONIC);

        List<class_1291> generatedEffects = new ArrayList<>();

        for (TonicBrewingRecipe recipe : manager.method_30027(TonicBrewingRecipe.Type.INSTANCE))
        {
            registry.addRecipe(new EmiTonicRecipe(recipe));

            if (generatedEffects.contains(recipe.outputEffect)) continue;
            List<class_1291> effects = new ArrayList<>();
            for (int i = 0; i < Math.min(recipe.applicationLimit, 3); i++) {
                effects.add(recipe.outputEffect);
                class_1799 thisStack = TonicUtil.getStack(effects);
                if (!AppendCreativeCategory.APPEND_GROUP.method_45412(thisStack))
                {
                    registry.addEmiStack(EmiStack.of(thisStack));
                    generatedEffects.add(recipe.outputEffect);
                }
            }
        }

    }
}
