package wintermourn.wintersappend.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import org.jetbrains.annotations.Nullable;
import wintermourn.wintersappend.config.AppendServerConfig;
import wintermourn.wintersappend.integration.emi.category.EmiTonicCategory;
import wintermourn.wintersappend.item.CatalystUtil;
import wintermourn.wintersappend.recipe.CatalystRecipe;
import wintermourn.wintersappend.screen.TonicStandScreen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5684;

public class EmiCatalystRecipe implements EmiRecipe {

    private final class_2960 id;
    private final class_2371<EmiIngredient> ingredients;
    private final List<EmiStack> output;
    private final int fuelCost;
    private final int purityCost;
    private final int brewTime;

    public EmiCatalystRecipe(CatalystRecipe recipe)
    {
        this.id = recipe.method_8114();

        class_2371<class_1856> recipeIngredients = recipe.method_8117();
        this.ingredients = class_2371.method_10213(4, EmiIngredient.of(class_1856.field_9017));
        this.ingredients.set(0, EmiIngredient.of(recipeIngredients.get(0)));
        this.ingredients.set(1, EmiIngredient.of(recipeIngredients.get(1)));
        this.ingredients.set(2, EmiIngredient.of(recipeIngredients.get(2)));
        this.ingredients.set(3, EmiIngredient.of(class_1856.method_8101(
            class_1844.method_8061(new class_1799(class_1802.field_8574), class_1847.field_8991)
        )));

        this.output = new ArrayList<>(1);
        this.output.add(0, EmiStack.of(CatalystUtil.getStack(recipe.catalystID)));

        this.fuelCost = recipe.fuelCost;
        this.purityCost = recipe.purityCost;
        this.brewTime = recipe.brewingTime;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return EmiTonicCategory.CATEGORY;
    }

    @Override
    public @Nullable class_2960 getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return this.ingredients;
    }

    @Override
    public List<EmiStack> getOutputs() {
        return this.output;
    }

    @Override
    public int getDisplayWidth() {
        return 112;
    }

    @Override
    public int getDisplayHeight() {
        return 60;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(TonicStandScreen.TEXTURE, 0, 0, 112, 60, 17, 15);
        //168, 74
        widgets.addSlot(ingredients.get(0), 62, 1);
        widgets.addSlot(ingredients.get(1), 42, 42);
        widgets.addSlot(ingredients.get(2), 82, 42);

        widgets.addSlot(output.get(0), 62, 42);

        widgets.addTexture(TonicStandScreen.TEXTURE, 44, 29,
            Math.round(18 * (this.fuelCost / 50f)), 4, 176, 33);
        widgets.addTexture(TonicStandScreen.TEXTURE, 44, 29,
            Math.round(18 * (this.fuelCost / 100f)), 4, 176, 29);
        widgets.addTexture(TonicStandScreen.TEXTURE, 35, 36,
            Math.round(27 * (this.purityCost / 120f)), 4, 176, 41);
        widgets.addTexture(TonicStandScreen.TEXTURE, 7, 45,
            11, 11, 176, 45);
        widgets.addTexture(TonicStandScreen.TEXTURE, 7, 45,
            11, 11, 209, 45);

        widgets.addTooltip(
            this.fuelCost > 0 ?
            List.of(
                class_5684.method_32662(class_2561.method_43469("recipe.winters_append.cost.fuelCost", this.fuelCost).method_30937()),
                class_5684.method_32662(class_2561.method_43471("recipe.winters_append.explainFuel").method_27692(class_124.field_1080).method_30937()),
                class_5684.method_32662(class_5244.field_41874.method_30937()),
                class_5684.method_32662(class_2561.method_43471("recipe.winters_append.cost.noPurity").method_27692(class_124.field_1065).method_30937()),
                class_5684.method_32662(class_2561.method_43469("recipe.winters_append.cost.fuelCost", this.fuelCost * AppendServerConfig.impureFuelPenalty).method_30937())
            ) :
            List.of(
                class_5684.method_32662(class_2561.method_43469("recipe.winters_append.cost.fuelCost", this.fuelCost).method_30937())
            ),
            43, 28, 20, 6
        );
        widgets.addTooltip(
            List.of(
                class_5684.method_32662(class_2561.method_43469("recipe.winters_append.cost.purityCost", this.purityCost).method_30937()),
                class_5684.method_32662(class_2561.method_43471("recipe.winters_append.explainPurity").method_27692(class_124.field_1080).method_30937())
            ),
            34, 35, 29, 6
        );
        widgets.addTooltip(
            List.of(
                class_5684.method_32662(class_2561.method_43469("recipe.winters_append.cost.time", this.brewTime / 20f).method_30937()),
                class_5684.method_32662(class_5244.field_41874.method_30937()),
                class_5684.method_32662(class_2561.method_43471("recipe.winters_append.cost.noPurity").method_27692(class_124.field_1065).method_30937()),
                class_5684.method_32662(class_2561.method_43469("recipe.winters_append.cost.time", this.brewTime / 20f * AppendServerConfig.impureTimePenalty).method_30937())
            ),
            81, 2, 9, 27
        );
        widgets.addTooltip(
            List.of(
                class_5684.method_32662(class_2561.method_43471("recipe.winters_append.type.catalyst").method_30937())
            ),
            0, 45, 18, 11
        );
    }
}
