package wintermourn.wintersappend.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import org.jetbrains.annotations.Nullable;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.integration.emi.category.EmiFuelCategory;
import wintermourn.wintersappend.screen.TonicStandScreen;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5684;
import net.minecraft.class_7923;

public class EmiFuelInfo implements EmiRecipe {
    final class_1792 item;
    final EmiIngredient emiIngredient;
    final int fuel;
    final int purity;

    public EmiFuelInfo(class_1792 item, int fuel, int purity)
    {
        this.item = item;
        this.emiIngredient = EmiStack.of(item);
        this.fuel = fuel;
        this.purity = purity;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return EmiFuelCategory.CATEGORY;
    }

    @Override
    public @Nullable class_2960 getId() {
        class_2960 itemId = class_7923.field_41178.method_10221(item);
        return new class_2960("generated", WintersAppend.MOD_ID +'/'+ itemId.method_12836() +'/'+ itemId.method_12832());
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(emiIngredient);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of();
    }

    @Override
    public int getDisplayWidth() {
        return 28 + 24;
    }

    @Override
    public int getDisplayHeight() {
        return 20;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        int offset = 1;
        widgets.addSlot(this.emiIngredient,0 + offset,0 + offset);

        widgets.addTexture(TonicStandScreen.TEXTURE, 18 + 2 + offset, 3 + offset,
            19, 6, 61, 43);
        widgets.addTexture(TonicStandScreen.TEXTURE, 18 + 2 + offset, 4 + offset,
            Math.round(18 * (this.fuel / 100f)), 4, 176, 29);
        widgets.addTexture(TonicStandScreen.TEXTURE, 18 + 2 + offset, 9 + offset,
            28, 6, 52, 50);
        widgets.addTexture(TonicStandScreen.TEXTURE, 18 + 2 + offset, 10 + offset,
            Math.round(27 * (this.purity / 120f)), 4, 176, 41);

        widgets.addTooltip(
            List.of(class_5684.method_32662(
                class_2561.method_43469("recipe.winters_append.fuel.fuel"+ (fuel > -1 ? "" : ".none"), fuel).method_30937()
            )),
            18 + 2 + offset, 3 + offset, 19, 6
        );
        widgets.addTooltip(
            List.of(class_5684.method_32662(
                class_2561.method_43469("recipe.winters_append.fuel.purity"+ (purity > -1 ? "" : ".none"), purity).method_30937()
            )),
            18 + 2 + offset, 9 + offset, 28, 6
        );
    }
}
