package wintermourn.wintersappend.item;

import org.jetbrains.annotations.Nullable;
import wintermourn.wintersappend.block.VariablyFertilizable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1752;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ExtendedBoneMealItem extends class_1752 {
    List<class_2561> tooltipContents;

    public ExtendedBoneMealItem(class_1793 settings) {
        super(settings);
        tooltipContents = new ArrayList<>();
    }
    public ExtendedBoneMealItem(class_1793 settings, List<class_2561> tooltip) {
        super(settings);
        tooltipContents = List.copyOf(tooltip);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);

        tooltip.addAll(tooltipContents);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2338 blockPos2 = blockPos.method_10093(context.method_8038());
        if (useOnFertilizable(context.method_8041(), world, blockPos, context.method_8041())) {
            if (!world.field_9236) {
                world.method_20290(1505, blockPos, 0);
            }

            return class_1269.method_29236(world.field_9236);
        } else {
            class_2680 blockState = world.method_8320(blockPos);
            boolean bl = blockState.method_26206(world, blockPos, context.method_8038());
            if (bl && method_7719(context.method_8041(), world, blockPos2, context.method_8038())) {
                if (!world.field_9236) {
                    world.method_20290(1505, blockPos2, 0);
                }

                return class_1269.method_29236(world.field_9236);
            } else {
                return class_1269.field_5811;
            }
        }
    }

    public static boolean useOnFertilizable(class_1799 stack, class_1937 world, class_2338 pos, class_1799 fertilizer) {
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_26204() instanceof VariablyFertilizable fertilizable) {
            if (fertilizable.method_9651(world, pos, blockState, world.field_9236)) {
                if (world instanceof class_3218) {
                    if (fertilizable.method_9650(world, world.field_9229, pos, blockState)) {
                        fertilizable.growWithItem((class_3218)world, world.field_9229, pos, blockState, fertilizer);
                    }

                    stack.method_7934(1);
                }

                return true;
            }
        }

        return false;
    }

}
