package wintermourn.wintersappend.item;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.nbt.*;
import org.jetbrains.annotations.Nullable;

import java.awt.*;
import java.util.*;
import java.util.function.IntFunction;

public class TonicUtil {
    public static final String TONIC_EFFECTS_KEY = "effects";
    private static final int DEFAULT_COLOR = 16253176;
    private static final Map<class_1291, Integer> TONIC_COLORS = new HashMap<>();
    private static final Map<class_1291, IntFunction<class_2561>> EFFECT_TEXT = new HashMap<>();
    private static final Map<class_1291, String> TONIC_NAMES = new HashMap<>();
    private static final class_2561 NONE_TEXT;
    private static final class_1799 TONIC_REP = new class_1799(AppendItems.TONIC);


    public static List<class_1799> registeredItems = new ArrayList<>();

//    static Identifier EMPTY = new Identifier(WintersAppend.MOD_ID, "empty");
//    public static final SimpleDefaultedRegistry<Object> TONICS = FabricRegistryBuilder.createDefaulted(
//            RegistryKey.ofRegistry(new Identifier(WintersAppend.MOD_ID, "tonic")), EMPTY).buildAndRegister();

    public static void registerColor(class_1291 effect, int color)
    {
        TONIC_COLORS.put(effect, color);
    }
    public static void registerName(class_1291 effect, @Translatable String translationKey)
    {
        TONIC_NAMES.put(effect, translationKey);
    }
    public static void registerText(class_1291 effect, IntFunction<class_2561> text)
    {
        EFFECT_TEXT.put(effect, text);
    }

    public static class_1799 getStack(List<class_1291> effects)
    {
        return getStack(effects.toArray(new class_1291[0]));
    }
    public static class_1799 getStack(List<class_1291> effects, int span)
    {
        class_1799 stack = getStack(effects.toArray(new class_1291[0]));
        TonicUtil.setEffectSpan(stack, span);
        return stack;
    }
    public static class_1799 getStack(TonicItem item, List<class_1291> effects)
    {
        return getStack(item, effects.toArray(new class_1291[0]));
    }
    public static class_1799 getStack(TonicItem item, List<class_1291> effects, int span)
    {
        class_1799 stack = getStack(item, effects.toArray(new class_1291[0]));
        TonicUtil.setEffectSpan(stack, span);
        return stack;
    }
    public static class_1799 getStack(class_1291... effects)
    {
        return getStack((TonicItem) AppendItems.TONIC, effects);
    }
    public static class_1799 getStack(TonicItem item, class_1291... effects)
    {
        class_1799 tonic = new class_1799(item);
        class_2487 nbt = tonic.method_7948();
        class_2499 effectNbt = new class_2499();

        Map<class_1291, Integer> effectData = new HashMap<>();
        for (class_1291 effect : effects)
        {
            if (effectData.containsKey(effect))
            {
                effectData.put(effect, effectData.get(effect) + 1);
            } else
            {
                effectData.put(effect, 0);
            }
        }
        for (Map.Entry<class_1291, Integer> entry : effectData.entrySet().stream().sorted().toList())
        {
            class_2960 id = class_7923.field_41174.method_10221(entry.getKey());
            assert id != null;
            class_2499 mini = new class_2499();
            mini.add(class_2519.method_23256(id.toString()));
            mini.add(class_2519.method_23256(entry.getValue().toString()));
            effectNbt.add(mini);
        }
        nbt.method_10566(TONIC_EFFECTS_KEY, effectNbt);

        return tonic;
    }
    public static class_1799 getRepresentative()
    {
        return TONIC_REP;
    }


    public static int getEffectSpan(class_1799 tonic)
    {
        class_2487 itemNbt = tonic.method_7948();
        if (!(tonic.method_7909() instanceof TonicItem)) return 0;
        if (!itemNbt.method_10545(TONIC_EFFECTS_KEY) || !itemNbt.method_10545("spanOffset"))
            return ((TonicItem) tonic.method_7909()).getEffectLifetime();

        return ((TonicItem) tonic.method_7909()).getEffectLifetime() + itemNbt.method_10550("spanOffset");
    }

    public static void setEffectSpan(class_1799 tonic, int time)
    {
        class_2487 itemNbt = tonic.method_7948();
        itemNbt.method_10569("spanOffset", time);
    }

    public static int getColor(class_1799 tonic)
    {
        class_2487 itemNbt = tonic.method_7948();
        if (!(tonic.method_7909() instanceof TonicItem)) return 0x385DC6;
        if (!itemNbt.method_10545(TONIC_EFFECTS_KEY) || itemNbt.method_10545("representative")) return DEFAULT_COLOR;

        Color finalColor = new Color(0x385DC6);

        class_2499 effects = itemNbt.method_10554(TONIC_EFFECTS_KEY, class_2520.field_33259);

        for (class_2520 effect : effects) {
            class_2960 effectId = class_2960.method_12829(((class_2499) effect).method_10608(0));
            if (effectId == null) continue;

            class_1291 status = class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;

            Color effectColor;

            if (TONIC_COLORS.containsKey(status))
                effectColor = new Color(TONIC_COLORS.get(status));
            else
                effectColor = new Color(status.method_5556());
            finalColor = new Color(
                (finalColor.getRed() + effectColor.getRed()) / 2,
                (finalColor.getGreen() + effectColor.getGreen()) / 2,
                (finalColor.getBlue() + effectColor.getBlue()) / 2
            );
        }

        return finalColor.getRGB();
    }
    public static int[] getColorRGB(class_1799 tonic)
    {
        class_2487 itemNbt = tonic.method_7948();
        if (!(tonic.method_7909() instanceof TonicItem)) return new int[]{0x38, 0x5D, 0xC6};
        if (!itemNbt.method_10545(TONIC_EFFECTS_KEY)) return new int[]{(DEFAULT_COLOR >> 16) & 255,(DEFAULT_COLOR >> 8) & 255, DEFAULT_COLOR & 255};

        Color finalColor = new Color(0x385DC6);

        class_2499 effects = itemNbt.method_10554(TONIC_EFFECTS_KEY, class_2520.field_33259);

        for (class_2520 effect : effects) {
            class_2960 effectId = class_2960.method_12829(((class_2499) effect).method_10608(0));
            if (effectId == null) continue;

            class_1291 status = class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;

            Color effectColor;

            if (TONIC_COLORS.containsKey(status))
                effectColor = new Color(TONIC_COLORS.get(status));
            else
                effectColor = new Color(status.method_5556());
            finalColor = new Color(
                (finalColor.getRed() + effectColor.getRed()) / 2,
                (finalColor.getGreen() + effectColor.getGreen()) / 2,
                (finalColor.getBlue() + effectColor.getBlue()) / 2
            );
        }

        return new int[]{finalColor.getRed(),finalColor.getGreen(),finalColor.getBlue()};
    }

    public static List<class_1293> getTonicEffectInstances(class_1799 tonic)
    {
        if (!(tonic.method_7909() instanceof TonicItem)) return null;

        class_2487 nbt = tonic.method_7948();
        List<class_1293> instances = new ArrayList<>();

        class_2499 effects = nbt.method_10554(TONIC_EFFECTS_KEY, class_2520.field_33259);

        for (class_2520 effect : effects) {
            class_2960 effectId = class_2960.method_12829(((class_2499) effect).method_10608(0));
            if (effectId == null) continue;
            int amplifier;
            try { amplifier = Integer.parseInt(((class_2499) effect).method_10608(1)); } catch (NumberFormatException ignored) {
                amplifier = 0;
            }

            class_1291 status = class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;

            instances.add(new class_1293(status, TonicUtil.getEffectSpan(tonic), amplifier));
        }

        return instances;
    }

    public static Map<class_1291, Integer> getTonicEffects(class_1799 tonic)
    {
        return getTonicEffects(tonic.method_7948());
    }

    public static Map<class_1291, Integer> getTonicEffects(class_2487 nbt)
    {
        Map<class_1291, Integer> effects = new HashMap<>();

        class_2499 effectsNbt = nbt.method_10554(TONIC_EFFECTS_KEY, class_2520.field_33259);

        for (class_2520 effect : effectsNbt) {
            class_2960 effectId = class_2960.method_12829(((class_2499) effect).method_10608(0));
            if (effectId == null) continue;
            int amplifier;
            try { amplifier = Integer.parseInt(((class_2499) effect).method_10608(1)); } catch (NumberFormatException e) {
                amplifier = 0;
            }

            class_1291 status = class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;

            effects.put(status, amplifier);
        }

        return effects;
    }

    /**
     * Creates a list of Status Effects, with one instance per effect.<br>
     * For example, Speed II and Haste IV would be <code>[speed, haste]</code>.
     */
    public static List<class_1291> getTonicEffectsList(class_1799 tonic)
    {
        return getTonicEffectsList(tonic.method_7948());
    }

    /**
     * Creates a list of Status Effects, with one instance per effect.<br>
     * For example, Speed II and Haste IV would be <code>[speed, haste]</code>.
     */
    public static List<class_1291> getTonicEffectsList(class_2487 nbt)
    {
        List<class_1291> effects = new ArrayList<>();

        class_2499 effectsNbt = nbt.method_10554(TONIC_EFFECTS_KEY, class_2520.field_33259);

        for (class_2520 effect : effectsNbt) {
            class_2960 effectId = class_2960.method_12829(((class_2499) effect).method_10608(0));
            if (effectId == null) continue;

            class_1291 status = class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;

            effects.add(status);
        }

        return effects;
    }

    /**
     * Creates a list of Status Effects, with equal duplicates to amplifiers.<br>
     * For example, Speed II would be <code>[speed, speed]</code>.
     */
    public static List<class_1291> getTonicEffectsListFlat(class_1799 tonic)
    {
        return getTonicEffectsListFlat(tonic.method_7948());
    }

    /**
     * Creates a list of Status Effects, with equal duplicates to amplifiers.<br>
     * For example, Speed II would be <code>[speed, speed]</code>.
     */
    public static List<class_1291> getTonicEffectsListFlat(class_2487 nbt)
    {
        List<class_1291> effects = new ArrayList<>();

        class_2499 effectsNbt = nbt.method_10554(TONIC_EFFECTS_KEY, class_2520.field_33259);

        for (class_2520 effect : effectsNbt) {
            class_2960 effectId = class_2960.method_12829(((class_2499) effect).method_10608(0));
            if (effectId == null) continue;
            int amplifier;
            try { amplifier = Integer.parseInt(((class_2499) effect).method_10608(1)); } catch (NumberFormatException ignored) {
                amplifier = 0;
            }
            class_1291 status = class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;

            for (int i = 0; i <= amplifier; i++) {effects.add(status);}
        }

        return effects;
    }

    @Nullable
    public static Pair<class_1291, Boolean> getPrimaryEffect(class_1799 tonic)
    {
        return getPrimaryEffect(tonic.method_7948());
    }

    @Nullable
    public static Pair<class_1291, Boolean> getPrimaryEffect(class_2487 nbt)
    {
        Map<class_1291, Integer> effects = getTonicEffects(nbt);
        Map.Entry<class_1291, Integer> highestEntry = null;
        boolean multiple = false;

        for (Map.Entry<class_1291, Integer> entry : effects.entrySet()) {
            if (highestEntry == null || highestEntry.getValue() < entry.getValue())
            {
                highestEntry = entry;
                multiple = false;
            } else
                multiple = true;
        }

        return highestEntry != null ? new Pair<>(highestEntry.getKey(), multiple) : new Pair<>(null, false);
    }

    public static class_2561 getName(class_1799 tonic)
    {
        Pair<class_1291, Boolean> primaryEffect = getPrimaryEffect(tonic);

        if (primaryEffect == null || primaryEffect.getFirst() == null) return class_2561.method_43471("tonic.name.none");
        if (primaryEffect.getSecond()) return class_2561.method_43471("tonic.mixture");
        if (TONIC_NAMES.containsKey(primaryEffect.getFirst())) return class_2561.method_43471(TONIC_NAMES.get(primaryEffect.getFirst()));
        return class_2561.method_43469("tonic.name.generic", primaryEffect.getFirst().method_5560());
    }

    public static int getEffectsCount(class_1799 tonic)
    {
        return getEffectsCount(tonic.method_7948());
    }

    public static int getEffectsCount(class_2487 nbt)
    {
        int count = 0;
        class_2499 list = nbt.method_10554(TONIC_EFFECTS_KEY, class_2520.field_33259);
        for (class_2520 element : list)
        {
            String amplifier = ((class_2499) element).method_10608(1);
            try {
                count += Integer.parseInt(amplifier) + 1;
            } catch (NumberFormatException ignored) {
                count += 1;
            }
        }

        return count;
    }

    public static void buildTooltip(class_1799 stack, List<class_2561> tooltip, double durationMultiplier)
    {

        if (stack.method_7909() instanceof TonicItem tonic)
        {
            int effectCount = getEffectsCount(stack);
            int maxEffects = tonic.getMaxEffects();
            buildTooltip(getTonicEffects(stack), tooltip, durationMultiplier, maxEffects - effectCount);

//            tooltip.add(ScreenTexts.SPACE);
//            if (effectCount < maxEffects)
//                tooltip.add(Text.translatable("tonic.fillLevel", TonicUtil.getEffectsCount(stack), maxEffects).formatted(Formatting.DARK_GRAY));
//            else
//                tooltip.add(Text.translatable("tonic.full").formatted(Formatting.DARK_GRAY));
        } else
        {
            buildTooltip(getTonicEffects(stack), tooltip, durationMultiplier, 0);
        }
    }

    public static void buildTooltip(Map<class_1291, Integer> effects, List<class_2561> tooltip, double durationMultiplier, int additionalSlots)
    {

        Iterator<Map.Entry<class_1291, Integer>> effectIterator;
        Iterator<Pair<class_1320, class_1322>> attributeIterator;

        List<Pair<class_1320, class_1322>> attributeModifiers = new ArrayList<>();
        class_1291 effect;
        class_5250 text;
        if (effects.isEmpty())
            if (additionalSlots > 0)
                for (int i = 0; i < additionalSlots; i++)
                {
                    tooltip.add(class_2561.method_43471("tonic.none").method_27692(class_124.field_1063));
                }
            else
                tooltip.add(NONE_TEXT);
        else
        {
            for (effectIterator = effects.entrySet().iterator(); effectIterator.hasNext();)
            {
                Map.Entry<class_1291, Integer> effectInstance = effectIterator.next();

                text = class_2561.method_43471(effectInstance.getKey().method_5567());
                effect = effectInstance.getKey();
                Map<class_1320, class_1322> attributes = effect.method_5565();

                if (!attributes.isEmpty()) {

                    for (Map.Entry<class_1320, class_1322> entry : attributes.entrySet()) {
                        class_1322 modifier = entry.getValue();
                        class_1322 copiedModifier = new class_1322(modifier.method_6185(), effect.method_5563(effectInstance.getValue(), modifier), modifier.method_6182());
                        attributeModifiers.add(new Pair<>(entry.getKey(), copiedModifier));
                    }
                }

                if (effectInstance.getValue() > 0) {
                    text = class_2561.method_43469("tonic.withAmplifier", text, class_2561.method_43471("potion.potency." + effectInstance.getValue()));
                }

                tooltip.add(class_2561.method_43469("tonic.effect_entry", text.method_27692(effect.method_18792().method_18793())));

                if (EFFECT_TEXT.containsKey(effect))
                {
                    tooltip.add(((class_5250)EFFECT_TEXT.get(effect).apply(effectInstance.getValue())).method_27692(class_124.field_1080));
                }
            }

            for (int i = 0; i < additionalSlots; i++)
            {
                tooltip.add(class_2561.method_43471("tonic.none").method_27692(class_124.field_1063));
            }
        }

        if (!attributeModifiers.isEmpty())
        {
            tooltip.add(class_5244.field_41874);
            tooltip.add(class_2561.method_43471("potion.whenDrank").method_27692(class_124.field_1065));

            attributeIterator = attributeModifiers.iterator();

            while (attributeIterator.hasNext())
            {
                Pair<class_1320, class_1322> attribute = attributeIterator.next();
                class_1322 modifier = attribute.getSecond();

                double value = modifier.method_6186();

                if (modifier.method_6182() != class_1322.class_1323.field_6328)
                    value *= 100;

                if (value > 0.0) {
                    tooltip.add(class_2561.method_43469("attribute.modifier.plus." + modifier.method_6182().method_6191(), class_1799.field_8029.format(value), class_2561.method_43471((attribute.getFirst()).method_26830())).method_27692(class_124.field_1078));
                } else if (value < 0.0) {
                    value *= -1.0;
                    tooltip.add(class_2561.method_43469("attribute.modifier.take." + modifier.method_6182().method_6191(), class_1799.field_8029.format(value), class_2561.method_43471((attribute.getFirst()).method_26830())).method_27692(class_124.field_1061));
                }
            }
        }
    }

    public static void registerCreativeItems(class_1761.class_7704 entries, class_1291 effect)
    {
        registerCreativeItems(entries, effect, 3);
    }
    public static void registerCreativeItems(class_1761.class_7704 entries, class_1291 effect, int maxLevel)
    {
        List<class_1291> currentDepth = new ArrayList<>();
        for (int i = 0; i < maxLevel; i++) {
            currentDepth.add(effect);

            class_1799 thisStack = getStack(currentDepth);
            entries.method_45420(thisStack);
            registeredItems.add(thisStack);
        }
    }

    static
    {
        NONE_TEXT = class_2561.method_43471("tonic.none").method_27692(class_124.field_1080);
        class_2487 compound = new class_2487();
        compound.method_10556("representative", true);
        TONIC_REP.method_7980(compound);

        registerText(class_1294.field_5898, i -> class_2561.method_43469("tonic.effect.absorption", (i+1) * 2));
    }
}
