package wintermourn.wintersappend.mixin.common;

import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.effects.DamageResistStatusEffect;

@Mixin(class_1297.class)
public class EntityMixin {
    @SuppressWarnings("UnreachableCode")
    @Inject(method = "isInvulnerableTo", at = @At("RETURN"), cancellable = true)
    private void invulnerabilityCheck(class_1282 source, CallbackInfoReturnable<Boolean> cir)
    {
        if (((Object) this) instanceof class_1309 entity)
        {
            for (class_1293 instance : entity.method_6026()) {
                if (instance.method_5579() instanceof DamageResistStatusEffect effect)
                {
                    if (effect.immuneSources.contains(source.method_48792().comp_1242()))
                    {
                        WintersAppend.LOGGER.info(effect.protectionPercentage + (effect.bonusProtectionAmplified * instance.method_5578()) +"%");
                        if (effect.protectionPercentage + (effect.bonusProtectionAmplified * instance.method_5578()) >= 1) cir.setReturnValue(true);
                    }
                }
            }
        }
    }
}
