package wintermourn.wintersappend.mixin.common;

import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_2718;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.attributes.PercentAttributes;
import wintermourn.wintersappend.effects.DamageResistStatusEffect;
import wintermourn.wintersappend.effects.ImmunizationStatusEffect;
import wintermourn.wintersappend.effects.MajorEffects;
import wintermourn.wintersappend.effects.PurityStatusEffect;

@Mixin(class_1309.class)
public class LivingEntityMixin {
    @SuppressWarnings("UnreachableCode")
    @Inject(method = "modifyAppliedDamage", at = @At(value = "RETURN"), cancellable = true)
    private void OnHurt(class_1282 source, float amount, CallbackInfoReturnable<Float> cir)
    {
        class_1309 me = (class_1309) ((Object) this);

        if (source.method_5529() instanceof class_1309 entity)
        {
            if (entity.method_6059(MajorEffects.CONCEALED)) entity.method_6016(MajorEffects.CONCEALED);
        }

        for (class_1293 instance : me.method_6026()) {
            if (instance.method_5579() instanceof DamageResistStatusEffect effect)
            {
                if (effect.immuneSources.contains(source.method_48792().comp_1242()))
                {
                    amount *= (float) (1.0 - effect.protectionPercentage - effect.bonusProtectionAmplified * instance.method_5578());
                }
            }
        }

        if (source.method_5526() != null)
        {
            WintersAppend.LOGGER.info(source.method_5526().toString());
            if (source.method_5526() instanceof class_1676)
            {
                if (me.method_6127().method_27306(PercentAttributes.RESISTANCE_PROJECTILE))
                {
                    amount *= 2 - (float) me.method_26825(PercentAttributes.RESISTANCE_PROJECTILE);
                }
            } else if (source.method_5526() instanceof class_1309)
            {
                if (me.method_6127().method_27306(PercentAttributes.RESISTANCE_PHYSICAL))
                {
                    amount *= 2 - (float) me.method_26825(PercentAttributes.RESISTANCE_PHYSICAL);
                }
            }
        }

        cir.setReturnValue(amount);
    }

//    @Inject(method = "addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z", at = @At("HEAD"), cancellable = true)
//    private void OnAddEffect(StatusEffectInstance effect, Entity source, CallbackInfoReturnable<Boolean> cir)
//    {
//        LivingEntity me = (LivingEntity) ((Object) this);
//
//        for (StatusEffectInstance instance : me.getStatusEffects()) {
//            if (instance.getEffectType() instanceof ImmunizationStatusEffect immunization)
//            {
//                if (immunization.effects.contains(effect.getEffectType()))
//                {
//                    cir.setReturnValue(false);
//                }
//            }
//        }
//    }

    @Inject(method = "canHaveStatusEffect", at = @At("RETURN"), cancellable = true)
    private void CanHaveEffect(class_1293 effect, CallbackInfoReturnable<Boolean> cir)
    {
        class_1309 me = (class_1309) ((Object) this);

        class_1291 statusEffectToRemove = null;
        for (class_1293 instance : me.method_6026()) {
            if (instance.method_5579() instanceof ImmunizationStatusEffect immunization)
            {
                if (immunization.effects.contains(effect.method_5579()))
                {
                    cir.setReturnValue(false);
                    break;
                }
            }
            if (instance.method_5579() instanceof PurityStatusEffect purity)
            {
                if (effect.method_5579().method_18792() == purity.PurificationCategory)
                {
                    cir.setReturnValue(false);

                    if (instance.method_5578() > 0)
                    {
                        me.method_26082(new class_1293(purity, instance.method_5584(), instance.method_5578() -1), null);
                    } else
                    {
                        statusEffectToRemove = purity; break;
                    }
                }
            }
        }

        if (statusEffectToRemove != null)
        {
            me.method_6016(statusEffectToRemove);
        }
    }

    @Redirect(method = "onStatusEffectApplied",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;sendEffectToControllingPlayer(Lnet/minecraft/entity/effect/StatusEffectInstance;)V"))
    private void FixPacketShite(class_1309 instance, class_1293 effect)
    {
        class_1293 guaranteedEffect = instance.method_6112(effect.method_5579());

        if (instance instanceof class_3222 player)
        {
            if (guaranteedEffect == null)
            {
                player.field_13987.method_14364(new class_2718(player.method_5628(), effect.method_5579()));
            }
        }
    }
}
