package wintermourn.wintersappend.recipe;

import com.google.gson.JsonArray;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.block.entity.TonicStandBlockEntity;
import wintermourn.wintersappend.item.AppendItems;
import wintermourn.wintersappend.item.CatalystUtil;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class CatalystRecipe extends TonicStandRecipe implements class_1860<TonicStandBlockEntity> {
    final class_2960 id;

    public final String catalystID;
    public final int color;

    public CatalystRecipe(class_2960 id, String output, class_2371<class_1856> input, int brewTime, int fuelCost, int purityCost)
    {
        this(id, output, input, brewTime, fuelCost, purityCost, -1);
    }
    public CatalystRecipe(class_2960 id, String output, class_2371<class_1856> input, int brewTime, int fuelCost, int purityCost, int color)
    {
        super(input, brewTime, fuelCost, purityCost);

        this.id = id;
        if (input.size() > 3) throw new ArithmeticException("Ingredients count too long (must be <=3)");

        class_2371<class_1856> ings = class_2371.method_10213(3, class_1856.field_9017);
        Collections.copy(ings, input);

        this.catalystID = output;
        this.color = color;
    }

    public boolean matches(TonicStandBlockEntity inventory, class_1937 world) {
        if (inventory.getFuel() <= 0 && this.fuelCost > 0) return false; //this.maxFuelCost / inventory.getFuelEfficiency()

        boolean[] matchedStacks = new boolean[3];
        for (class_1856 ingredient : this.ingredients) {
            boolean matched = false;
            for (int j = 0; j < 3; j++) {
                if (matchedStacks[j]) continue;
                if (ingredient.method_8093(inventory.method_5438(j + 1))) {
                    class_1799 inventoryStack = inventory.method_5438(j + 1);
                    if (inventoryStack.method_7909() == AppendItems.CATALYST)
                    {
                        boolean validCatalyst = false;
                        for (class_1799 item : ingredient.method_8105())
                        {
                            if (!item.method_7985() || !inventoryStack.method_7985()) continue;
                            assert inventoryStack.method_7969() != null;
                            assert item.method_7969() != null;
                            if (Objects.equals(item.method_7969().method_10558("id"), inventoryStack.method_7969().method_10558("id")))
                            {
                                validCatalyst = true; break;
                            }
                        }
                        if (!validCatalyst) continue;
                    }
                    matched = true;
                    matchedStacks[j] = true;
                    break;
                }
            }
            if (!matched) {
                return false;
            }
        }

        class_1799 outputSlot = inventory.method_5438(TonicStandBlockEntity.OUTPUT_SLOT_ID);

        return class_1844.method_8063(outputSlot) == class_1847.field_8991;
    }

    @Override
    public boolean isOutputValid(class_1799 output) {
        return class_1844.method_8063(output) == class_1847.field_8991;
    }

    public class_1799 craft(TonicStandBlockEntity inventory, class_5455 registryManager) {
        return color > -1 ? CatalystUtil.getStack(catalystID, color) : CatalystUtil.getStack(catalystID);
    }

    @Override
    public class_2371<class_1856> method_8117() {
        return ingredients;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    @Override
    public class_1799 method_8110(class_5455 registryManager) {
        return color > -1 ? CatalystUtil.getStack(catalystID, color) : CatalystUtil.getStack(catalystID);
    }

//    public ItemStack getOutput(DynamicRegistryManager registryManager) {
//        return output;
//    }

    public class_2960 method_8114() {
        return this.id;
    }
    public boolean method_8118() { return true; }

    public class_1865<?> method_8119() {
        return CatalystRecipeSerializer.INSTANCE;
    }

    public static class Type implements class_3956<CatalystRecipe>
    {
        private Type() {}
        public static final Type INSTANCE = new Type();

        public static final class_2960 ID = new class_2960(WintersAppend.MOD_ID, "catalyst_brewing");
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    class CatalystRecipeJson
    {
        Integer purity_needed;
        Integer fuel_price;
        Integer brewing_time;
        Integer color;
        JsonArray inputs;
        String output;
    }

}
