package wintermourn.wintersappend.recipe;


import com.google.gson.*;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import wintermourn.wintersappend.WintersAppend;

public class CatalystRecipeSerializer implements class_1865<CatalystRecipe>
{
    private CatalystRecipeSerializer() {}

    public static final CatalystRecipeSerializer INSTANCE = new CatalystRecipeSerializer();
    public static final class_2960 ID = new class_2960(WintersAppend.MOD_ID, "catalyst_recipe");

    public CatalystRecipe method_8121(class_2960 id, JsonObject json) {
        CatalystRecipe.CatalystRecipeJson recipeJson = new Gson().fromJson(json, CatalystRecipe.CatalystRecipeJson.class);

        if (recipeJson.inputs == null) throw new JsonSyntaxException("Recipe inputs array is missing!");
        if (recipeJson.output == null) throw new JsonSyntaxException("Recipe output string is missing!");

        class_2371<class_1856> ingredients = class_2371.method_10213(3, class_1856.field_9017);

        for (int i = 0; i < 3; i++) {
            JsonElement element = recipeJson.inputs.get(i);

            if (element == null || element instanceof JsonNull)
            {
                break;
            }
            ingredients.set(i, class_1856.method_8102(element, true));
        }

        String output = recipeJson.output;

        int brewTime = recipeJson.brewing_time != null ? recipeJson.brewing_time :  200;
        int fuelCost = recipeJson.fuel_price != null ? recipeJson.fuel_price :  10;
        int purityCost = recipeJson.purity_needed != null ? recipeJson.purity_needed :  10;
        int color = recipeJson.color != null ? recipeJson.color : -1;

        return new CatalystRecipe(id, output, ingredients, brewTime, fuelCost, purityCost, color);
    }

    public CatalystRecipe method_8122(class_2960 id, class_2540 buf) {
        class_2371<class_1856> ingredients = class_2371.method_10213(3, class_1856.field_9017);
        for (int i = 0; i < 3; i++) {
            ingredients.set(i, class_1856.method_8086(buf));
        }
        int brewTime = buf.readInt();
        int fuelCost = buf.readInt();
        int purityCost = buf.readInt();
        int color = buf.readInt();
        String output = buf.method_19772();

        return new CatalystRecipe(id, output, ingredients, brewTime, fuelCost, purityCost, color);
    }

    public void write(class_2540 buf, CatalystRecipe recipe) {
        for (int i = 0; i < 3; i++) {
            recipe.ingredients.get(i).method_8088(buf);
        }
        buf.writeInt(recipe.brewingTime);
        buf.writeInt(recipe.fuelCost);
        buf.writeInt(recipe.purityCost);
        buf.writeInt(recipe.color);
        buf.method_10814(recipe.catalystID);
    }
}
