package wintermourn.wintersappend.recipe;


import com.google.gson.*;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import wintermourn.wintersappend.WintersAppend;

public class TonicBrewingRecipeSerializer implements class_1865<TonicBrewingRecipe>
{
    private TonicBrewingRecipeSerializer() {}

    public static final TonicBrewingRecipeSerializer INSTANCE = new TonicBrewingRecipeSerializer();
    public static final class_2960 ID = new class_2960(WintersAppend.MOD_ID, "tonic_stand_recipe");

    public TonicBrewingRecipe method_8121(class_2960 id, JsonObject json) {
        TonicBrewingRecipe.TonicStandRecipeJson recipeJson = new Gson().fromJson(json, TonicBrewingRecipe.TonicStandRecipeJson.class);

        if (recipeJson.inputs == null) throw new JsonSyntaxException("Recipe inputs array is missing!");
        if (recipeJson.output == null) throw new JsonSyntaxException("Recipe output id is missing!");

        class_2371<class_1856> ingredients = class_2371.method_10213(3, class_1856.field_9017);

        for (int i = 0; i < 3; i++) {
            JsonElement element = recipeJson.inputs.get(i);

            if (element == null || element instanceof JsonNull)
            {
                break;
            }
            ingredients.set(i, class_1856.method_8102(element, true));
        }

        class_2960 output = new class_2960(recipeJson.output);

        int brewTime = recipeJson.brewing_time != null ? recipeJson.brewing_time :  200;
        int fuelCost = recipeJson.fuel_price != null ? recipeJson.fuel_price :  10;
        int purityCost = recipeJson.purity_needed != null ? recipeJson.purity_needed :  10;
        int applicationLimit = recipeJson.application_limit != null ? recipeJson.application_limit :  99;
        int span_offset = recipeJson.span_offset != null ? recipeJson.span_offset :  0;

        return new TonicBrewingRecipe(id, output, ingredients, brewTime, fuelCost, purityCost, applicationLimit, span_offset);
    }

    public TonicBrewingRecipe method_8122(class_2960 id, class_2540 buf) {
        class_2371<class_1856> ingredients = class_2371.method_10213(3, class_1856.field_9017);
        for (int i = 0; i < 3; i++) {
            ingredients.set(i, class_1856.method_8086(buf));
        }
        int brewTime = buf.readInt();
        int fuelCost = buf.readInt();
        int purityCost = buf.readInt();
        int applicationLimit = buf.readInt();
        int spanOffset = buf.readInt();
        class_2960 statusEffect = buf.method_10810();

        return new TonicBrewingRecipe(id, statusEffect, ingredients, brewTime, fuelCost, purityCost, applicationLimit, spanOffset);
    }

    public void write(class_2540 buf, TonicBrewingRecipe recipe) {
        for (int i = 0; i < 3; i++) {
            recipe.ingredients.get(i).method_8088(buf);
        }
        buf.writeInt(recipe.brewingTime);
        buf.writeInt(recipe.fuelCost);
        buf.writeInt(recipe.purityCost);
        buf.writeInt(recipe.applicationLimit);
        buf.writeInt(recipe.spanOffset);
        buf.method_10812(recipe.output);
    }
}
