package wintermourn.wintersappend.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_757;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.client.gui.widget.UntexturedButtonWidget;
import wintermourn.wintersappend.networking.AppendMessages;

public class TonicStandScreen extends class_465<TonicStandScreenHandler> {
    public static final class_2960 TEXTURE = new class_2960(WintersAppend.MOD_ID,"textures/gui/container/tonic_stand.png");
    boolean buttonHovered = false;

    UntexturedButtonWidget brewingButtonWidget;

    public TonicStandScreen(TonicStandScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.field_25267 = (this.field_2792 - this.field_22793.method_27525(this.field_22785)) / 2;

        int x = (field_22789 - field_2792) / 2;
        int y = (field_22790 - field_2779) / 2;
        brewingButtonWidget = new UntexturedButtonWidget(
                x + 17, y + 61, 18, 11, this::onBrewingModeToggle);
        this.method_37063(brewingButtonWidget);
    }

    @Override
    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(1f,1f,1f,1f);
        RenderSystem.setShaderTexture(0, TEXTURE);

        int x = (field_22789 - field_2792) / 2;
        int y = (field_22790 - field_2779) / 2;

        context.method_25302(TEXTURE, x, y, 0,0, field_2792, field_2779);

        renderProgressArrow(context, x + 98, y + 16);
        renderFuelBar(context, x + 61, y + 44);
        renderPurityBar(context, x + 52, y + 51);
        renderModeButton(context, x + 17, y + 60, field_2797.getBrewingMode(), brewingButtonWidget.method_49606());

        //render progress
        //render arrow
    }

    private void renderProgressArrow(class_332 ctx, int x, int y)
    {
        ctx.method_25302(TEXTURE, x, y, 176,0, 9, Math.round(28 * field_2797.getScaledProgress()));
    }

    private void renderFuelBar(class_332 ctx, int x, int y)
    {
        ctx.method_25302(TEXTURE, x, y, 176,33, Math.round(18 * field_2797.getScaledFuel()), 4);
        ctx.method_25302(TEXTURE, x, y, 176,29, Math.round(18 * field_2797.getScaledFuelEstimate()), 4);
    }
    private void renderModeButton(class_332 ctx, int x, int y, int mode, boolean buttonHovered)
    {
        ctx.method_25302(TEXTURE, x + mode * 7, y, 176 + (buttonHovered ? 11 : 0),45, 11, 11);
        ctx.method_25302(TEXTURE, x + mode * 7, y, 198 + mode * 11,45, 11, 11);
    }
    private void renderPurityBar(class_332 ctx, int x, int y)
    {
        ctx.method_51422(1,0.6f,0.5f,1);
        ctx.method_25302(TEXTURE, x, y, 176,37, Math.round(27 * field_2797.getScaledPurity()), 4);
        ctx.method_51422(0.6f,1,0.65f,1);
        ctx.method_25302(TEXTURE, x, y, 176,37, Math.round(27 * field_2797.getScaledPurityEstimate()), 4);
        ctx.method_51422(1,1,1,1);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        method_2380(context, mouseX, mouseY);
    }

    public void onBrewingModeToggle(class_4185 button)
    {
        field_2797.setBrewingMode(field_2797.getBrewingMode() == 1 ? 0 : 1);
        ClientPlayNetworking.send(
                AppendMessages.TOGGLE_BREWING_MODE,
                PacketByteBufs.create().method_10807(field_2797.blockEntity.method_11016()));
    }
}
