/*
 * Decompiled with CFR 0.152.
 */
package wintermourn.wintersappend.block.entity;

import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import wintermourn.wintersappend.block.entity.AppendBlockEntities;
import wintermourn.wintersappend.config.AppendFuelsConfig;
import wintermourn.wintersappend.config.AppendServerConfig;
import wintermourn.wintersappend.item.TonicUtil;
import wintermourn.wintersappend.networking.AppendMessages;
import wintermourn.wintersappend.recipe.CatalystRecipe;
import wintermourn.wintersappend.recipe.TonicBrewingRecipe;
import wintermourn.wintersappend.recipe.TonicStandRecipe;
import wintermourn.wintersappend.screen.TonicStandScreenHandler;

public class TonicStandBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
class_1278 {
    public static final int MAX_FUEL = 100;
    public static final int MAX_PURITY = 120;
    public static final int OUTPUT_SLOT_ID = 0;
    public static final int FUEL_SLOT_ID = 4;
    public static final int PURITY_SLOT_ID = 5;
    float fuelEfficiency = 1.0f;
    float purityEfficiency = 1.0f;
    float timeEfficiency = 1.0f;
    class_2371<class_1799> inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> TonicStandBlockEntity.this.brewTime;
                case 1 -> TonicStandBlockEntity.this.fuel;
                case 2 -> TonicStandBlockEntity.this.purity;
                case 3 -> TonicStandBlockEntity.this.getFuelEstimate();
                case 4 -> TonicStandBlockEntity.this.getMaxBrewTime();
                case 5 -> TonicStandBlockEntity.this.getPurityEstimate();
                case 6 -> TonicStandBlockEntity.this.brewingMode;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    TonicStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    TonicStandBlockEntity.this.fuel = value;
                    break;
                }
                case 2: {
                    TonicStandBlockEntity.this.purity = value;
                    break;
                }
                case 6: {
                    TonicStandBlockEntity.this.brewingMode = value;
                }
            }
        }

        public int method_17389() {
            return 7;
        }
    };
    boolean amIDirty = false;
    int brewTime = 0;
    int fuel = 0;
    int purity = 0;
    int fuelPartialTicks = 0;
    int purityPartialTicks = 0;
    int brewingMode = 0;
    TonicStandRecipe recipe;

    public TonicStandBlockEntity(class_2338 pos, class_2680 state) {
        super(AppendBlockEntities.TONIC_STAND_BLOCK_ENTITY, pos, state);
    }

    public static TonicStandBlockEntity withEfficiency(class_2338 pos, class_2680 state, float fuel, float purity, float time) {
        TonicStandBlockEntity entity = new TonicStandBlockEntity(pos, state);
        entity.fuelEfficiency = fuel;
        entity.purityEfficiency = purity;
        entity.timeEfficiency = time;
        return entity;
    }

    public void setEfficiency(float fuel, float purity, float time) {
        this.fuelEfficiency = fuel;
        this.purityEfficiency = purity;
        this.timeEfficiency = time;
    }

    public float getPurityEfficiency() {
        return 1.0f;
    }

    public int getMaxPurity() {
        return 120;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.amIDirty = true;
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        class_1799 slotItem = (class_1799)this.inventory.get(slot);
        this.inventory.set(slot, (Object)class_1799.field_8037);
        this.amIDirty = true;
        this.method_5431();
        return slotItem;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.amIDirty = true;
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    protected class_1703 createScreenHandler(int syncId, class_1661 playerInventory) {
        return new TonicStandScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return new TonicStandScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TonicStandBlockEntity me) {
        int value;
        class_1799 purityStack;
        int value2;
        class_1799 fuelStack;
        if (world.method_8608()) {
            return;
        }
        if (me.isOutputValid()) {
            if (me.hasRecipe()) {
                me.increaseCraftProgress();
                TonicStandBlockEntity.markDirty(world, pos, state);
                if (me.isCraftingFinished()) {
                    me.craftItem();
                    me.resetProgress();
                    TonicStandBlockEntity.markDirty(world, pos, state);
                }
            } else if (me.decreaseCraftProgress()) {
                me.amIDirty = true;
            }
        } else if (me.decreaseCraftProgress()) {
            me.amIDirty = true;
        }
        if (me.amIDirty) {
            TonicStandBlockEntity.markDirty(world, pos, state);
        }
        if (!(fuelStack = (class_1799)me.inventory.get(4)).method_7960() && (value2 = AppendFuelsConfig.GetHeatFuel(fuelStack)) > -1 && me.fuel <= me.getMaxFuel() - value2) {
            me.fuel += value2;
            fuelStack.method_7934(1);
        }
        if (!(purityStack = (class_1799)me.inventory.get(5)).method_7960() && (value = AppendFuelsConfig.GetPurity(purityStack)) > -1 && me.purity <= me.getMaxPurity() - value) {
            me.purity += value;
            purityStack.method_7934(1);
        }
    }

    public static void markDirty(class_1937 world, class_2338 pos, class_2680 myState) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TonicStandBlockEntity) {
            TonicStandBlockEntity me = (TonicStandBlockEntity)class_25862;
            me.method_5431();
        }
    }

    private boolean decreaseCraftProgress() {
        if (this.brewTime > 1) {
            this.brewTime -= 2;
            return true;
        }
        if (this.brewTime > 0) {
            --this.brewTime;
            return true;
        }
        return false;
    }

    private void resetProgress() {
        this.brewTime = 0;
    }

    private void craftItem() {
        class_1799 outputStack = (class_1799)this.inventory.get(0);
        this.inventory.set(0, (Object)this.recipe.craft(this, null));
        ((class_1799)this.inventory.get(1)).method_7934(1);
        ((class_1799)this.inventory.get(2)).method_7934(1);
        ((class_1799)this.inventory.get(3)).method_7934(1);
        if (!AppendServerConfig.spendFuelDuringBrew) {
            boolean hasPurity = (float)this.getPurity() > (float)this.recipe.purityCost / this.getPurityEfficiency();
            this.fuel -= (int)((float)Math.round((float)this.recipe.fuelCost / this.fuelEfficiency) * (hasPurity ? 1.0f : AppendServerConfig.impureFuelPenalty));
            this.purity -= Math.round((float)this.recipe.purityCost / this.getPurityEfficiency());
            if (this.fuel < 0) {
                this.fuel = 0;
            }
            if (this.purity < 0) {
                this.purity = 0;
            }
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            for (class_1657 player : this.field_11863.method_18456()) {
                ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)AppendMessages.BREWING_FINISHED, (class_2540)PacketByteBufs.create().method_10807(this.field_11867).method_10793((class_1799)this.inventory.get(0)));
            }
        }
    }

    private boolean isCraftingFinished() {
        return this.hasRecipe() && this.getMaxBrewTime() <= this.brewTime;
    }

    private void increaseCraftProgress() {
        ++this.brewTime;
        if (AppendServerConfig.spendFuelDuringBrew) {
            float fuelPrice = (float)this.recipe.fuelCost / ((float)this.recipe.brewingTime * this.timeEfficiency * (this.purity > 0 ? 1.0f : AppendServerConfig.impureTimePenalty)) * this.fuelEfficiency * (float)(this.fuelPartialTicks + 1) * (this.purity > 0 ? 1.0f : AppendServerConfig.impureFuelPenalty);
            float purityPrice = (float)this.recipe.purityCost / ((float)this.recipe.brewingTime * this.timeEfficiency * (this.purity > 0 ? 1.0f : AppendServerConfig.impureTimePenalty)) * this.purityEfficiency * (float)(this.purityPartialTicks + 1);
            if (fuelPrice < 1.0f) {
                ++this.fuelPartialTicks;
            } else {
                this.fuel -= (int)fuelPrice;
                this.fuelPartialTicks = 0;
            }
            if (purityPrice < 1.0f) {
                ++this.purityPartialTicks;
            } else {
                this.purity -= (int)purityPrice;
                this.purityPartialTicks = 0;
            }
        }
    }

    boolean hasRecipe() {
        if (this.method_10997() == null) {
            return false;
        }
        Optional recipe = switch (this.brewingMode) {
            case 0 -> this.method_10997().method_8433().method_8132((class_3956)TonicBrewingRecipe.Type.INSTANCE, (class_1263)this, this.field_11863);
            case 1 -> this.method_10997().method_8433().method_8132((class_3956)CatalystRecipe.Type.INSTANCE, (class_1263)this, this.field_11863);
            default -> Optional.empty();
        };
        this.recipe = recipe.orElse(null);
        return this.recipe != null;
    }

    boolean isOutputValid() {
        class_1799 stack = (class_1799)this.inventory.get(0);
        return this.recipe != null && this.recipe.isOutputValid(stack);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("fuel", this.fuel);
        if (this.fuelPartialTicks > 0) {
            nbt.method_10569("fuelP", this.fuelPartialTicks);
        }
        nbt.method_10569("brewTime", this.brewTime);
        nbt.method_10569("purity", this.purity);
        if (this.purityPartialTicks > 0) {
            nbt.method_10569("purityP", this.purityPartialTicks);
        }
        nbt.method_10569("brewingMode", this.brewingMode);
        class_2499 stacks = new class_2499();
        for (class_1799 stack : this.inventory) {
            class_2487 item = new class_2487();
            stack.method_7953(item);
            stacks.add((Object)item);
        }
        nbt.method_10566("contents", (class_2520)stacks);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fuel = nbt.method_10550("fuel");
        this.fuelPartialTicks = nbt.method_10550("fuelP");
        this.brewTime = nbt.method_10550("brewTime");
        this.purity = nbt.method_10550("purity");
        this.purityPartialTicks = nbt.method_10550("purityP");
        this.brewingMode = nbt.method_10550("brewingMode");
        class_2499 stacks = nbt.method_10554("contents", 10);
        for (int i = 0; i < stacks.size(); ++i) {
            class_2520 class_25202 = stacks.method_10534(i);
            if (!(class_25202 instanceof class_2487)) continue;
            class_2487 compound = (class_2487)class_25202;
            class_1799 stack = class_1799.method_7915((class_2487)compound);
            this.inventory.set(i, (Object)(stack != null ? stack : class_1799.field_8037));
        }
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getMaxFuel() {
        return 100;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public int getMaxBrewTime() {
        if (this.hasRecipe()) {
            boolean hasPurity = (float)this.getPurity() > (float)this.recipe.purityCost / this.getPurityEfficiency();
            return Math.round((float)this.recipe.brewingTime * (hasPurity ? 1.0f : AppendServerConfig.impureTimePenalty));
        }
        return 9999;
    }

    public float getBrewPercent() {
        return (float)this.getBrewTime() / (float)this.getMaxBrewTime();
    }

    @Nullable
    public Integer getFluidColor() {
        if (((class_1799)this.inventory.get(0)).method_7960()) {
            return null;
        }
        return TonicUtil.getColor((class_1799)this.inventory.get(0));
    }

    public int[] getFluidColorRGB() {
        if (((class_1799)this.inventory.get(0)).method_7960()) {
            return new int[]{0, 0, 0};
        }
        return TonicUtil.getColorRGB((class_1799)this.inventory.get(0));
    }

    public void setOutputStack(class_1799 stack) {
        this.inventory.set(0, (Object)stack);
    }

    public int getBrewingMode() {
        return this.brewingMode;
    }

    public void setBrewingMode(int mode) {
        this.brewingMode = mode;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getFuelEstimate() {
        if (this.hasRecipe()) {
            boolean hasPurity;
            boolean bl = hasPurity = (float)this.getPurity() > (float)this.recipe.purityCost / this.getPurityEfficiency();
            if (AppendServerConfig.spendFuelDuringBrew) {
                return this.fuel - (int)Math.ceil((float)this.recipe.fuelCost / this.fuelEfficiency * (hasPurity ? 1.0f : AppendServerConfig.impureFuelPenalty) * (1.0f - this.getBrewPercent()));
            }
            return this.fuel - Math.round((float)this.recipe.fuelCost / this.fuelEfficiency * (hasPurity ? 1.0f : AppendServerConfig.impureFuelPenalty));
        }
        return this.getFuel();
    }

    private int getPurityEstimate() {
        if (this.hasRecipe()) {
            if (AppendServerConfig.spendFuelDuringBrew) {
                return this.purity - (int)Math.ceil((float)this.recipe.purityCost / this.getPurityEfficiency() * (1.0f - this.getBrewPercent()));
            }
            return this.purity - Math.round((float)this.recipe.purityCost / this.getPurityEfficiency());
        }
        return this.getPurity();
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.winters_append.tonic_stand");
    }

    public int getPurity() {
        return this.purity;
    }

    public boolean hasOutput() {
        return !((class_1799)this.inventory.get(0)).method_7960();
    }
}

