/*
 * Decompiled with CFR 0.152.
 */
package wintermourn.wintersappend.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

public class AppendFuelsConfig {
    public static final Path CONFIG_PATH = Paths.get("config/wintermourn/winters_append", "fuels.json");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Map<class_2960, class_3545<Integer, Integer>> Fuels = new HashMap<class_2960, class_3545<Integer, Integer>>();
    public static final Map<class_2960, class_3545<Integer, Integer>> RegisteredFuels = new HashMap<class_2960, class_3545<Integer, Integer>>();

    public static void LoadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                AppendFuelsConfig.LoadValues();
            } else {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                JsonObject defaultJsonObject = AppendFuelsConfig.createDefaultConfig();
                AppendFuelsConfig.saveConfig(defaultJsonObject);
                AppendFuelsConfig.LoadValues();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static JsonObject GetConfig() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                JsonObject defaultJsonObject = AppendFuelsConfig.createDefaultConfig();
                AppendFuelsConfig.saveConfig(defaultJsonObject);
            }
            FileReader fileReader = new FileReader(CONFIG_PATH.toFile());
            return JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void LoadValues() {
        try (FileReader fileReader = new FileReader(CONFIG_PATH.toFile());){
            JsonObject jsonObject = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
            AppendFuelsConfig.LoadValues(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void LoadValues(JsonObject jsonObject) {
        Fuels = new HashMap<class_2960, class_3545<Integer, Integer>>();
        try {
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject entryObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                int fuel = entryObject.has("fuel") ? entryObject.get("fuel").getAsInt() : -1;
                int purity = entryObject.has("purity") ? entryObject.get("purity").getAsInt() : -1;
                Fuels.put(class_2960.method_12829((String)((String)entry.getKey())), (class_3545<Integer, Integer>)new class_3545((Object)fuel, (Object)purity));
            }
            for (Map.Entry entry : RegisteredFuels.entrySet()) {
                if (Fuels.containsKey(entry.getKey())) continue;
                Fuels.put((class_2960)entry.getKey(), (class_3545<Integer, Integer>)((class_3545)entry.getValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static JsonObject createDefaultConfig() {
        JsonObject defaultJsonObject = new JsonObject();
        JsonObject blazeDefault = new JsonObject();
        blazeDefault.addProperty("fuel", (Number)100);
        JsonObject gypsoDefault = new JsonObject();
        gypsoDefault.addProperty("purity", (Number)60);
        defaultJsonObject.add("minecraft:blaze_powder", (JsonElement)blazeDefault);
        defaultJsonObject.add("winters_append:gypsophila", (JsonElement)gypsoDefault);
        return defaultJsonObject;
    }

    private static void saveConfig(JsonObject jsonObject) throws IOException {
        try (FileWriter fileWriter = new FileWriter(CONFIG_PATH.toFile());){
            GSON.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        }
    }

    public static int GetHeatFuel(class_1799 stack) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (Fuels.containsKey(id)) {
            return (Integer)Fuels.get(id).method_15442();
        }
        return -1;
    }

    public static int GetPurity(class_1799 stack) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (Fuels.containsKey(id)) {
            return (Integer)Fuels.get(id).method_15441();
        }
        return -1;
    }

    public static void TransferFuelsFromServer(class_2540 buf) {
        JsonObject config = JsonParser.parseString((String)buf.method_19772()).getAsJsonObject();
        AppendFuelsConfig.LoadValues(config);
    }

    public static class_2540 CreateFuelsPacket() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(Objects.requireNonNull(AppendFuelsConfig.GetConfig()).toString());
        return buf;
    }
}

