/*
 * Decompiled with CFR 0.152.
 */
package wintermourn.wintersappend.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_5244;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import wintermourn.wintersappend.config.AppendServerConfig;
import wintermourn.wintersappend.integration.emi.category.EmiTonicCategory;
import wintermourn.wintersappend.item.TonicUtil;
import wintermourn.wintersappend.recipe.TonicBrewingRecipe;
import wintermourn.wintersappend.screen.TonicStandScreen;

public class EmiTonicRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final class_2371<EmiIngredient> ingredients;
    private final EmiIngredient output;
    private final int fuelCost;
    private final int purityCost;
    private final int brewTime;
    private final int applicationLimit;
    private final int spanOffset;

    public EmiTonicRecipe(TonicBrewingRecipe recipe) {
        this.id = recipe.method_8114();
        class_2371<class_1856> recipeIngredients = recipe.method_8117();
        this.ingredients = class_2371.method_10213((int)4, (Object)EmiIngredient.of((class_1856)class_1856.field_9017));
        this.ingredients.set(0, (Object)EmiIngredient.of((class_1856)((class_1856)recipeIngredients.get(0))));
        this.ingredients.set(1, (Object)EmiIngredient.of((class_1856)((class_1856)recipeIngredients.get(1))));
        this.ingredients.set(2, (Object)EmiIngredient.of((class_1856)((class_1856)recipeIngredients.get(2))));
        this.ingredients.set(3, (Object)EmiIngredient.of((class_1856)class_1856.method_8101((class_1799[])new class_1799[]{class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991), TonicUtil.getRepresentative()})));
        ArrayList<class_1799> tonics = new ArrayList<class_1799>(Math.min(recipe.applicationLimit, AppendServerConfig.defaultTonicEffects));
        ArrayList<class_1291> effectList = new ArrayList<class_1291>();
        for (int i = 0; i < Math.min(recipe.applicationLimit, AppendServerConfig.defaultTonicEffects); ++i) {
            effectList.add(recipe.outputEffect);
            if (recipe.spanOffset != 0) {
                tonics.add(TonicUtil.getStack(effectList, recipe.spanOffset));
                continue;
            }
            tonics.add(TonicUtil.getStack(effectList));
        }
        this.output = EmiIngredient.of((class_1856)class_1856.method_8101((class_1799[])tonics.toArray(new class_1799[0])));
        this.fuelCost = recipe.fuelCost;
        this.purityCost = recipe.purityCost;
        this.brewTime = recipe.brewingTime;
        this.applicationLimit = recipe.applicationLimit;
        this.spanOffset = recipe.spanOffset;
    }

    public EmiRecipeCategory getCategory() {
        return EmiTonicCategory.CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.ingredients;
    }

    public List<EmiStack> getOutputs() {
        return this.output.getEmiStacks();
    }

    public int getDisplayWidth() {
        return 112;
    }

    public int getDisplayHeight() {
        return 60;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(TonicStandScreen.TEXTURE, 0, 0, 112, 60, 17, 15);
        widgets.addSlot((EmiIngredient)this.ingredients.get(0), 62, 1);
        widgets.addSlot((EmiIngredient)this.ingredients.get(1), 42, 42);
        widgets.addSlot((EmiIngredient)this.ingredients.get(2), 82, 42);
        widgets.addSlot(this.output, 62, 42);
        widgets.addTexture(TonicStandScreen.TEXTURE, 44, 29, Math.round(18.0f * ((float)this.fuelCost / 50.0f)), 4, 176, 33);
        widgets.addTexture(TonicStandScreen.TEXTURE, 44, 29, Math.round(18.0f * ((float)this.fuelCost / 100.0f)), 4, 176, 29);
        widgets.addTexture(TonicStandScreen.TEXTURE, 35, 36, Math.round(27.0f * ((float)this.purityCost / 120.0f)), 4, 176, 41);
        widgets.addTexture(TonicStandScreen.TEXTURE, 0, 45, 11, 11, 176, 45);
        widgets.addTexture(TonicStandScreen.TEXTURE, 0, 45, 11, 11, 198, 45);
        int iconsOffset = 0;
        if (this.applicationLimit < 99) {
            widgets.addTexture(TonicStandScreen.TEXTURE, 74, 33, 11, 8, 209, 0);
            widgets.addTooltip(List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.cost.limit", (Object[])new Object[]{this.applicationLimit}).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.explainLimit", (Object[])new Object[]{this.applicationLimit}).method_27692(class_124.field_1080).method_30937())), 74, 33, 11, 8);
            iconsOffset += 11;
        }
        if (this.spanOffset != 0) {
            if (this.spanOffset > 0) {
                widgets.addTexture(TonicStandScreen.TEXTURE, 75 + iconsOffset, 35, 10, 4, 209, 12);
                widgets.addTooltip(List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)"recipe.winters_append.output.span.good").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.output.span.good.desc", (Object[])new Object[]{class_3544.method_15439((int)this.spanOffset)}).method_27692(class_124.field_1080).method_30937())), 75 + iconsOffset, 35, 10, 4);
            } else {
                widgets.addTexture(TonicStandScreen.TEXTURE, 75 + iconsOffset, 35, 10, 4, 209, 16);
                widgets.addTooltip(List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)"recipe.winters_append.output.span.bad").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.output.span.bad.desc", (Object[])new Object[]{class_3544.method_15439((int)(-this.spanOffset))}).method_27692(class_124.field_1080).method_30937())), 75 + iconsOffset, 35, 10, 4);
            }
        }
        widgets.addTooltip(this.fuelCost > 0 ? List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.cost.fuelCost", (Object[])new Object[]{this.fuelCost}).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43471((String)"recipe.winters_append.explainFuel").method_27692(class_124.field_1080).method_30937()), class_5684.method_32662((class_5481)class_5244.field_41874.method_30937()), class_5684.method_32662((class_5481)class_2561.method_43471((String)"recipe.winters_append.cost.noPurity").method_27692(class_124.field_1065).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.cost.fuelCost", (Object[])new Object[]{Float.valueOf((float)this.fuelCost * AppendServerConfig.impureFuelPenalty)}).method_30937())) : List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.cost.fuelCost", (Object[])new Object[]{this.fuelCost}).method_30937())), 43, 28, 20, 6);
        widgets.addTooltip(List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.cost.purityCost", (Object[])new Object[]{this.purityCost}).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43471((String)"recipe.winters_append.explainPurity").method_27692(class_124.field_1080).method_30937())), 34, 35, 29, 6);
        widgets.addTooltip(List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.cost.time", (Object[])new Object[]{Float.valueOf((float)this.brewTime / 20.0f)}).method_30937()), class_5684.method_32662((class_5481)class_5244.field_41874.method_30937()), class_5684.method_32662((class_5481)class_2561.method_43471((String)"recipe.winters_append.cost.noPurity").method_27692(class_124.field_1065).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43469((String)"recipe.winters_append.cost.time", (Object[])new Object[]{Float.valueOf((float)this.brewTime / 20.0f * AppendServerConfig.impureTimePenalty)}).method_30937())), 81, 2, 9, 27);
        widgets.addTooltip(List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)"recipe.winters_append.type.tonic").method_30937())), 0, 45, 18, 11);
    }
}

