/*
 * Decompiled with CFR 0.152.
 */
package wintermourn.wintersappend.item;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import wintermourn.wintersappend.item.AppendItems;
import wintermourn.wintersappend.item.TonicItem;

public class TonicUtil {
    public static final String TONIC_EFFECTS_KEY = "effects";
    private static final int DEFAULT_COLOR = 0xF800F8;
    private static final Map<class_1291, Integer> TONIC_COLORS = new HashMap<class_1291, Integer>();
    private static final Map<class_1291, IntFunction<class_2561>> EFFECT_TEXT = new HashMap<class_1291, IntFunction<class_2561>>();
    private static final Map<class_1291, String> TONIC_NAMES = new HashMap<class_1291, String>();
    private static final class_2561 NONE_TEXT;
    private static final class_1799 TONIC_REP;
    public static List<class_1799> registeredItems;

    public static void registerColor(class_1291 effect, int color) {
        TONIC_COLORS.put(effect, color);
    }

    public static void registerName(class_1291 effect, @Translatable String translationKey) {
        TONIC_NAMES.put(effect, translationKey);
    }

    public static void registerText(class_1291 effect, IntFunction<class_2561> text) {
        EFFECT_TEXT.put(effect, text);
    }

    public static class_1799 getStack(List<class_1291> effects) {
        return TonicUtil.getStack(effects.toArray(new class_1291[0]));
    }

    public static class_1799 getStack(List<class_1291> effects, int span) {
        class_1799 stack = TonicUtil.getStack(effects.toArray(new class_1291[0]));
        TonicUtil.setEffectSpan(stack, span);
        return stack;
    }

    public static class_1799 getStack(TonicItem item, List<class_1291> effects) {
        return TonicUtil.getStack(item, effects.toArray(new class_1291[0]));
    }

    public static class_1799 getStack(TonicItem item, List<class_1291> effects, int span) {
        class_1799 stack = TonicUtil.getStack(item, effects.toArray(new class_1291[0]));
        TonicUtil.setEffectSpan(stack, span);
        return stack;
    }

    public static class_1799 getStack(class_1291 ... effects) {
        return TonicUtil.getStack((TonicItem)AppendItems.TONIC, effects);
    }

    public static class_1799 getStack(TonicItem item, class_1291 ... effects) {
        class_1799 tonic = new class_1799((class_1935)item);
        class_2487 nbt = tonic.method_7948();
        class_2499 effectNbt = new class_2499();
        HashMap<class_1291, Integer> effectData = new HashMap<class_1291, Integer>();
        for (class_1291 effect : effects) {
            if (effectData.containsKey(effect)) {
                effectData.put(effect, (Integer)effectData.get(effect) + 1);
                continue;
            }
            effectData.put(effect, 0);
        }
        for (Map.Entry entry : effectData.entrySet().stream().sorted().toList()) {
            class_2960 id = class_7923.field_41174.method_10221((Object)((class_1291)entry.getKey()));
            assert (id != null);
            class_2499 mini = new class_2499();
            mini.add((Object)class_2519.method_23256((String)id.toString()));
            mini.add((Object)class_2519.method_23256((String)((Integer)entry.getValue()).toString()));
            effectNbt.add((Object)mini);
        }
        nbt.method_10566(TONIC_EFFECTS_KEY, (class_2520)effectNbt);
        return tonic;
    }

    public static class_1799 getRepresentative() {
        return TONIC_REP;
    }

    public static int getEffectSpan(class_1799 tonic) {
        class_2487 itemNbt = tonic.method_7948();
        if (!(tonic.method_7909() instanceof TonicItem)) {
            return 0;
        }
        if (!itemNbt.method_10545(TONIC_EFFECTS_KEY) || !itemNbt.method_10545("spanOffset")) {
            return ((TonicItem)tonic.method_7909()).getEffectLifetime();
        }
        return ((TonicItem)tonic.method_7909()).getEffectLifetime() + itemNbt.method_10550("spanOffset");
    }

    public static void setEffectSpan(class_1799 tonic, int time) {
        class_2487 itemNbt = tonic.method_7948();
        itemNbt.method_10569("spanOffset", time);
    }

    public static int getColor(class_1799 tonic) {
        class_2487 itemNbt = tonic.method_7948();
        if (!(tonic.method_7909() instanceof TonicItem)) {
            return 3694022;
        }
        if (!itemNbt.method_10545(TONIC_EFFECTS_KEY) || itemNbt.method_10545("representative")) {
            return 0xF800F8;
        }
        Color finalColor = new Color(3694022);
        class_2499 effects = itemNbt.method_10554(TONIC_EFFECTS_KEY, 9);
        for (class_2520 effect : effects) {
            class_1291 status;
            class_2960 effectId = class_2960.method_12829((String)((class_2499)effect).method_10608(0));
            if (effectId == null || (status = (class_1291)class_7923.field_41174.method_10223(effectId)) == null) continue;
            Color effectColor = TONIC_COLORS.containsKey(status) ? new Color(TONIC_COLORS.get(status)) : new Color(status.method_5556());
            finalColor = new Color((finalColor.getRed() + effectColor.getRed()) / 2, (finalColor.getGreen() + effectColor.getGreen()) / 2, (finalColor.getBlue() + effectColor.getBlue()) / 2);
        }
        return finalColor.getRGB();
    }

    public static int[] getColorRGB(class_1799 tonic) {
        class_2487 itemNbt = tonic.method_7948();
        if (!(tonic.method_7909() instanceof TonicItem)) {
            return new int[]{56, 93, 198};
        }
        if (!itemNbt.method_10545(TONIC_EFFECTS_KEY)) {
            return new int[]{248, 0, 248};
        }
        Color finalColor = new Color(3694022);
        class_2499 effects = itemNbt.method_10554(TONIC_EFFECTS_KEY, 9);
        for (class_2520 effect : effects) {
            class_1291 status;
            class_2960 effectId = class_2960.method_12829((String)((class_2499)effect).method_10608(0));
            if (effectId == null || (status = (class_1291)class_7923.field_41174.method_10223(effectId)) == null) continue;
            Color effectColor = TONIC_COLORS.containsKey(status) ? new Color(TONIC_COLORS.get(status)) : new Color(status.method_5556());
            finalColor = new Color((finalColor.getRed() + effectColor.getRed()) / 2, (finalColor.getGreen() + effectColor.getGreen()) / 2, (finalColor.getBlue() + effectColor.getBlue()) / 2);
        }
        return new int[]{finalColor.getRed(), finalColor.getGreen(), finalColor.getBlue()};
    }

    public static List<class_1293> getTonicEffectInstances(class_1799 tonic) {
        if (!(tonic.method_7909() instanceof TonicItem)) {
            return null;
        }
        class_2487 nbt = tonic.method_7948();
        ArrayList<class_1293> instances = new ArrayList<class_1293>();
        class_2499 effects = nbt.method_10554(TONIC_EFFECTS_KEY, 9);
        for (class_2520 effect : effects) {
            int amplifier;
            class_2960 effectId = class_2960.method_12829((String)((class_2499)effect).method_10608(0));
            if (effectId == null) continue;
            try {
                amplifier = Integer.parseInt(((class_2499)effect).method_10608(1));
            }
            catch (NumberFormatException ignored) {
                amplifier = 0;
            }
            class_1291 status = (class_1291)class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;
            instances.add(new class_1293(status, TonicUtil.getEffectSpan(tonic), amplifier));
        }
        return instances;
    }

    public static Map<class_1291, Integer> getTonicEffects(class_1799 tonic) {
        return TonicUtil.getTonicEffects(tonic.method_7948());
    }

    public static Map<class_1291, Integer> getTonicEffects(class_2487 nbt) {
        HashMap<class_1291, Integer> effects = new HashMap<class_1291, Integer>();
        class_2499 effectsNbt = nbt.method_10554(TONIC_EFFECTS_KEY, 9);
        for (class_2520 effect : effectsNbt) {
            int amplifier;
            class_2960 effectId = class_2960.method_12829((String)((class_2499)effect).method_10608(0));
            if (effectId == null) continue;
            try {
                amplifier = Integer.parseInt(((class_2499)effect).method_10608(1));
            }
            catch (NumberFormatException e) {
                amplifier = 0;
            }
            class_1291 status = (class_1291)class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;
            effects.put(status, amplifier);
        }
        return effects;
    }

    public static List<class_1291> getTonicEffectsList(class_1799 tonic) {
        return TonicUtil.getTonicEffectsList(tonic.method_7948());
    }

    public static List<class_1291> getTonicEffectsList(class_2487 nbt) {
        ArrayList<class_1291> effects = new ArrayList<class_1291>();
        class_2499 effectsNbt = nbt.method_10554(TONIC_EFFECTS_KEY, 9);
        for (class_2520 effect : effectsNbt) {
            class_1291 status;
            class_2960 effectId = class_2960.method_12829((String)((class_2499)effect).method_10608(0));
            if (effectId == null || (status = (class_1291)class_7923.field_41174.method_10223(effectId)) == null) continue;
            effects.add(status);
        }
        return effects;
    }

    public static List<class_1291> getTonicEffectsListFlat(class_1799 tonic) {
        return TonicUtil.getTonicEffectsListFlat(tonic.method_7948());
    }

    public static List<class_1291> getTonicEffectsListFlat(class_2487 nbt) {
        ArrayList<class_1291> effects = new ArrayList<class_1291>();
        class_2499 effectsNbt = nbt.method_10554(TONIC_EFFECTS_KEY, 9);
        for (class_2520 effect : effectsNbt) {
            int amplifier;
            class_2960 effectId = class_2960.method_12829((String)((class_2499)effect).method_10608(0));
            if (effectId == null) continue;
            try {
                amplifier = Integer.parseInt(((class_2499)effect).method_10608(1));
            }
            catch (NumberFormatException ignored) {
                amplifier = 0;
            }
            class_1291 status = (class_1291)class_7923.field_41174.method_10223(effectId);
            if (status == null) continue;
            for (int i = 0; i <= amplifier; ++i) {
                effects.add(status);
            }
        }
        return effects;
    }

    @Nullable
    public static Pair<class_1291, Boolean> getPrimaryEffect(class_1799 tonic) {
        return TonicUtil.getPrimaryEffect(tonic.method_7948());
    }

    @Nullable
    public static Pair<class_1291, Boolean> getPrimaryEffect(class_2487 nbt) {
        Map<class_1291, Integer> effects = TonicUtil.getTonicEffects(nbt);
        Map.Entry<class_1291, Integer> highestEntry = null;
        boolean multiple = false;
        for (Map.Entry<class_1291, Integer> entry : effects.entrySet()) {
            if (highestEntry == null || (Integer)highestEntry.getValue() < entry.getValue()) {
                highestEntry = entry;
                multiple = false;
                continue;
            }
            multiple = true;
        }
        return highestEntry != null ? new Pair((Object)((class_1291)highestEntry.getKey()), (Object)multiple) : new Pair(null, (Object)false);
    }

    public static class_2561 getName(class_1799 tonic) {
        Pair<class_1291, Boolean> primaryEffect = TonicUtil.getPrimaryEffect(tonic);
        if (primaryEffect == null || primaryEffect.getFirst() == null) {
            return class_2561.method_43471((String)"tonic.name.none");
        }
        if (((Boolean)primaryEffect.getSecond()).booleanValue()) {
            return class_2561.method_43471((String)"tonic.mixture");
        }
        if (TONIC_NAMES.containsKey(primaryEffect.getFirst())) {
            return class_2561.method_43471((String)TONIC_NAMES.get(primaryEffect.getFirst()));
        }
        return class_2561.method_43469((String)"tonic.name.generic", (Object[])new Object[]{((class_1291)primaryEffect.getFirst()).method_5560()});
    }

    public static int getEffectsCount(class_1799 tonic) {
        return TonicUtil.getEffectsCount(tonic.method_7948());
    }

    public static int getEffectsCount(class_2487 nbt) {
        int count = 0;
        class_2499 list = nbt.method_10554(TONIC_EFFECTS_KEY, 9);
        for (class_2520 element : list) {
            String amplifier = ((class_2499)element).method_10608(1);
            try {
                count += Integer.parseInt(amplifier) + 1;
            }
            catch (NumberFormatException ignored) {
                ++count;
            }
        }
        return count;
    }

    public static void buildTooltip(class_1799 stack, List<class_2561> tooltip, double durationMultiplier) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof TonicItem) {
            TonicItem tonic = (TonicItem)class_17922;
            int effectCount = TonicUtil.getEffectsCount(stack);
            int maxEffects = tonic.getMaxEffects();
            TonicUtil.buildTooltip(TonicUtil.getTonicEffects(stack), tooltip, durationMultiplier, maxEffects - effectCount);
        } else {
            TonicUtil.buildTooltip(TonicUtil.getTonicEffects(stack), tooltip, durationMultiplier, 0);
        }
    }

    public static void buildTooltip(Map<class_1291, Integer> effects, List<class_2561> tooltip, double durationMultiplier, int additionalSlots) {
        ArrayList<Pair> attributeModifiers = new ArrayList<Pair>();
        if (effects.isEmpty()) {
            if (additionalSlots > 0) {
                for (i = 0; i < additionalSlots; ++i) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tonic.none").method_27692(class_124.field_1063));
                }
            } else {
                tooltip.add(NONE_TEXT);
            }
        } else {
            for (Map.Entry<class_1291, Integer> effectInstance : effects.entrySet()) {
                class_5250 text = class_2561.method_43471((String)effectInstance.getKey().method_5567());
                class_1291 effect = effectInstance.getKey();
                Map attributes = effect.method_5565();
                if (!attributes.isEmpty()) {
                    for (Map.Entry entry : attributes.entrySet()) {
                        class_1322 modifier = (class_1322)entry.getValue();
                        class_1322 copiedModifier = new class_1322(modifier.method_6185(), effect.method_5563(effectInstance.getValue().intValue(), modifier), modifier.method_6182());
                        attributeModifiers.add(new Pair((Object)((class_1320)entry.getKey()), (Object)copiedModifier));
                    }
                }
                if (effectInstance.getValue() > 0) {
                    text = class_2561.method_43469((String)"tonic.withAmplifier", (Object[])new Object[]{text, class_2561.method_43471((String)("potion.potency." + effectInstance.getValue()))});
                }
                tooltip.add((class_2561)class_2561.method_43469((String)"tonic.effect_entry", (Object[])new Object[]{text.method_27692(effect.method_18792().method_18793())}));
                if (!EFFECT_TEXT.containsKey(effect)) continue;
                tooltip.add((class_2561)((class_5250)EFFECT_TEXT.get(effect).apply(effectInstance.getValue())).method_27692(class_124.field_1080));
            }
            for (i = 0; i < additionalSlots; ++i) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tonic.none").method_27692(class_124.field_1063));
            }
        }
        if (!attributeModifiers.isEmpty()) {
            tooltip.add(class_5244.field_41874);
            tooltip.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1065));
            for (Pair attribute : attributeModifiers) {
                class_1322 modifier = (class_1322)attribute.getSecond();
                double value = modifier.method_6186();
                if (modifier.method_6182() != class_1322.class_1323.field_6328) {
                    value *= 100.0;
                }
                if (value > 0.0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + modifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(value), class_2561.method_43471((String)((class_1320)attribute.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(value < 0.0)) continue;
                tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + modifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(value *= -1.0), class_2561.method_43471((String)((class_1320)attribute.getFirst()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }

    public static void registerCreativeItems(class_1761.class_7704 entries, class_1291 effect) {
        TonicUtil.registerCreativeItems(entries, effect, 3);
    }

    public static void registerCreativeItems(class_1761.class_7704 entries, class_1291 effect, int maxLevel) {
        ArrayList<class_1291> currentDepth = new ArrayList<class_1291>();
        for (int i = 0; i < maxLevel; ++i) {
            currentDepth.add(effect);
            class_1799 thisStack = TonicUtil.getStack(currentDepth);
            entries.method_45420(thisStack);
            registeredItems.add(thisStack);
        }
    }

    static {
        TONIC_REP = new class_1799((class_1935)AppendItems.TONIC);
        registeredItems = new ArrayList<class_1799>();
        NONE_TEXT = class_2561.method_43471((String)"tonic.none").method_27692(class_124.field_1080);
        class_2487 compound = new class_2487();
        compound.method_10556("representative", true);
        TONIC_REP.method_7980(compound);
        TonicUtil.registerText(class_1294.field_5898, i -> class_2561.method_43469((String)"tonic.effect.absorption", (Object[])new Object[]{(i + 1) * 2}));
    }
}

