/*
 * Decompiled with CFR 0.152.
 */
package wintermourn.wintersappend.recipe;

import com.google.gson.JsonArray;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import wintermourn.wintersappend.WintersAppend;
import wintermourn.wintersappend.block.entity.TonicStandBlockEntity;
import wintermourn.wintersappend.item.AppendItems;
import wintermourn.wintersappend.item.TonicItem;
import wintermourn.wintersappend.item.TonicUtil;
import wintermourn.wintersappend.recipe.TonicBrewingRecipeSerializer;
import wintermourn.wintersappend.recipe.TonicStandRecipe;

public class TonicBrewingRecipe
extends TonicStandRecipe
implements class_1860<TonicStandBlockEntity> {
    final class_2960 id;
    public final int applicationLimit;
    public final int spanOffset;
    public final class_2960 output;
    public final class_1291 outputEffect;
    public final class_1799 outputStack;

    public TonicBrewingRecipe(class_2960 id, class_2960 output, class_2371<class_1856> input, int brewTime, int fuelCost, int purityCost) {
        this(id, output, input, brewTime, fuelCost, purityCost, 99, 0);
    }

    public TonicBrewingRecipe(class_2960 id, class_2960 output, class_2371<class_1856> input, int brewTime, int fuelCost, int purityCost, int applicationLimit, int spanOffset) {
        super(input, brewTime, fuelCost, purityCost);
        this.id = id;
        if (input.size() > 3) {
            throw new ArithmeticException("Ingredients count too long (must be <=3)");
        }
        class_2371 ings = class_2371.method_10213((int)3, (Object)class_1856.field_9017);
        Collections.copy(ings, input);
        this.output = output;
        this.outputEffect = (class_1291)class_7923.field_41174.method_10223(output);
        this.outputStack = TonicUtil.getStack(this.outputEffect);
        this.applicationLimit = applicationLimit;
        this.spanOffset = spanOffset;
    }

    public boolean matches(TonicStandBlockEntity inventory, class_1937 world) {
        TonicItem item;
        class_1792 class_17922;
        if (inventory.getFuel() <= 0 && this.fuelCost > 0) {
            return false;
        }
        boolean[] matchedStacks = new boolean[3];
        for (class_1856 ingredient : this.ingredients) {
            boolean matched = false;
            for (int j = 0; j < 3; ++j) {
                if (matchedStacks[j] || !ingredient.method_8093(inventory.method_5438(j + 1))) continue;
                class_1799 inventoryStack = inventory.method_5438(j + 1);
                if (inventoryStack.method_7909() == AppendItems.CATALYST) {
                    boolean validCatalyst = false;
                    for (class_1799 item2 : ingredient.method_8105()) {
                        if (!item2.method_7985() || !inventoryStack.method_7985()) continue;
                        assert (inventoryStack.method_7969() != null);
                        assert (item2.method_7969() != null);
                        if (!Objects.equals(item2.method_7969().method_10558("id"), inventoryStack.method_7969().method_10558("id"))) continue;
                        validCatalyst = true;
                        break;
                    }
                    if (!validCatalyst) continue;
                }
                matched = true;
                matchedStacks[j] = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        class_1799 outputSlot = inventory.method_5438(0);
        Map<class_1291, Integer> effects = TonicUtil.getTonicEffects(outputSlot);
        return class_1844.method_8063((class_1799)outputSlot) == class_1847.field_8991 || (class_17922 = outputSlot.method_7909()) instanceof TonicItem && (item = (TonicItem)class_17922).getMaxEffects() > TonicUtil.getEffectsCount(outputSlot) && (!effects.containsKey(this.outputEffect) || effects.get(this.outputEffect) + 1 < this.applicationLimit);
    }

    @Override
    public boolean isOutputValid(class_1799 output) {
        TonicItem item;
        class_1792 class_17922;
        return class_1844.method_8063((class_1799)output) == class_1847.field_8991 || (class_17922 = output.method_7909()) instanceof TonicItem && (item = (TonicItem)class_17922).getMaxEffects() > TonicUtil.getEffectsCount(output);
    }

    @Override
    public class_1799 craft(TonicStandBlockEntity inventory, class_5455 registryManager) {
        class_1799 output;
        class_1799 outputStack = inventory.method_5438(0);
        if (!outputStack.method_7960() && outputStack.method_7909() instanceof TonicItem) {
            List<class_1291> effects = TonicUtil.getTonicEffectsListFlat(outputStack);
            WintersAppend.LOGGER.info(effects.toString());
            effects.add(this.outputEffect);
            output = TonicUtil.getStack(effects);
        } else {
            output = TonicUtil.getStack(this.outputEffect);
        }
        TonicUtil.setEffectSpan(output, this.spanOffset + (outputStack.method_7985() ? Objects.requireNonNull(outputStack.method_7969()).method_10550("spanOffset") : 0));
        return output;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.outputStack;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return TonicBrewingRecipeSerializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public static class Type
    implements class_3956<TonicBrewingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final class_2960 ID = new class_2960("winters_append", "tonic_brewing");

        private Type() {
        }
    }

    class TonicStandRecipeJson {
        Integer purity_needed;
        Integer span_offset;
        Integer fuel_price;
        Integer brewing_time;
        JsonArray inputs;
        String output;
        Integer application_limit;

        TonicStandRecipeJson() {
        }
    }
}

