/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creepersdifferentstart.item;

import net.mcreator.creepersdifferentstart.procedures.FlintPickaxeAdditionalDropConditionProcedure;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FlintPickaxeItem
extends PickaxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 48;
        }

        public float getSpeed() {
            return 2.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_STONE_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public FlintPickaxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)1.0f, (float)-3.0f)));
    }

    public boolean isCorrectToolForDrops(ItemStack itemstack, BlockState blockstate) {
        return super.isCorrectToolForDrops(itemstack, blockstate) && FlintPickaxeAdditionalDropConditionProcedure.execute(blockstate);
    }
}

