/*
 * Decompiled with CFR 0.152.
 */
package net.treset.audio_hotkeys.audiolevels;

import net.minecraft.class_310;
import net.minecraft.class_315;
import net.treset.audio_hotkeys.config.States;
import net.treset.audio_hotkeys.gui.AudioOverlay;
import net.treset.audio_hotkeys.gui.OverlayManager;
import net.treset.audio_hotkeys.gui.TextureCoordinate;
import net.treset.audio_hotkeys.tools.MathTools;
import net.treset.audio_hotkeys.tools.objects.AudioState;
import net.treset.audio_hotkeys.tools.objects.VolumeTarget;
import net.treset.vanillaconfig.config.BooleanConfig;
import net.treset.vanillaconfig.config.IntegerConfig;
import net.treset.vanillaconfig.config.base.BaseConfig;
import net.treset.vanillaconfig.config.config_type.ConfigType;
import net.treset.vanillaconfig.tools.TextTools;

public class AudioLevels {
    private static class_315 opt = class_310.method_1551().field_1690;

    public static void toggleMute(VolumeTarget t) {
        if (t == VolumeTarget.SUBTITLES) {
            AudioLevels.toggleSubtitles();
            return;
        }
        AudioLevels.updateSoundLevels();
        for (AudioState e : States.STATES) {
            if (e.target != t) continue;
            AudioLevels.setMute(e, !e.muted);
            if (e.muted) {
                AudioLevels.updateSoundLevels();
                AudioLevels.setSoundLevel(e, 0);
                OverlayManager.drawOverlay(new AudioOverlay(String.format(TextTools.translateOrDefault((String)"string.audiohotkeys.mute"), TextTools.translateOrDefault((String)e.name)), TextureCoordinate.MUTE, 2000));
                continue;
            }
            opt = class_310.method_1551().field_1690;
            if (opt == null) {
                return;
            }
            if (opt.method_71978(e.target.getCategory()) == 0.0f) {
                AudioLevels.setSoundLevel(e, e.unmuteVolume);
                OverlayManager.drawOverlay(new AudioOverlay(String.format(TextTools.translateOrDefault((String)"string.audiohotkeys.unmute"), TextTools.translateOrDefault((String)e.name), e.unmuteVolume), TextureCoordinate.UNMUTE, 2000));
                continue;
            }
            int currentVolume = (int)(opt.method_71978(e.target.getCategory()) * 100.0f);
            OverlayManager.drawOverlay(new AudioOverlay(String.format(TextTools.translateOrDefault((String)"string.audiohotkeys.unmute_failed"), TextTools.translateOrDefault((String)e.name), currentVolume), TextureCoordinate.UNMUTE, 2000));
        }
        AudioLevels.updateSoundLevels();
    }

    public static void changeSoundLevel(VolumeTarget t, int value) {
        for (AudioState e : States.STATES) {
            if (e.target != t) continue;
            opt = class_310.method_1551().field_1690;
            if (opt == null) {
                return;
            }
            int currentVolume = (int)(opt.method_71978(e.target.getCategory()) * 100.0f);
            int targetVolume = (int)MathTools.clamp(currentVolume + value, 0.0f, 100.0f);
            AudioLevels.setSoundLevel(e, targetVolume);
            currentVolume = (int)(opt.method_71978(e.target.getCategory()) * 100.0f);
            if (value > 0) {
                OverlayManager.drawOverlay(new AudioOverlay(String.format(TextTools.translateOrDefault((String)"string.audiohotkeys.increase"), TextTools.translateOrDefault((String)e.name), Math.abs(value), currentVolume), TextureCoordinate.LOUDER, 2000));
                continue;
            }
            OverlayManager.drawOverlay(new AudioOverlay(String.format(TextTools.translateOrDefault((String)"string.audiohotkeys.decrease"), TextTools.translateOrDefault((String)e.name), Math.abs(value), currentVolume), TextureCoordinate.QUIETER, 2000));
        }
        AudioLevels.updateSoundLevels();
    }

    public static void toggleSubtitles() {
        opt = class_310.method_1551().field_1690;
        if (opt == null) {
            return;
        }
        AudioLevels.setMute(States.SUBTITLES, !States.SUBTITLES.muted);
        opt.method_42443().method_41748((Object)(!States.SUBTITLES.muted ? 1 : 0));
        if (((Boolean)opt.method_42443().method_41753()).booleanValue()) {
            OverlayManager.drawOverlay(new AudioOverlay(String.format(TextTools.translateOrDefault((String)"string.audiohotkeys.activate"), TextTools.translateOrDefault((String)States.SUBTITLES.name)), TextureCoordinate.UNMUTE, 2000));
        } else {
            OverlayManager.drawOverlay(new AudioOverlay(String.format(TextTools.translateOrDefault((String)"string.audiohotkeys.deactivate"), TextTools.translateOrDefault((String)States.SUBTITLES.name)), TextureCoordinate.MUTE, 2000));
        }
    }

    public static void setSoundLevel(AudioState m, int value) {
        opt = class_310.method_1551().field_1690;
        if (opt == null) {
            return;
        }
        double targetVolume = MathTools.clamp((float)value / 100.0f, 0.0f, 1.0f);
        opt.method_45578(m.target.getCategory()).method_41748((Object)targetVolume);
    }

    public static void updateSoundLevels() {
        if (opt == null) {
            opt = class_310.method_1551().field_1690;
        }
        for (AudioState e : States.STATES) {
            if (e == States.SUBTITLES || e.muted || opt == null) continue;
            AudioLevels.setUnmuteVolume(e, (int)(opt.method_1630(e.target.getCategory()) * 100.0f));
        }
        if (opt != null) {
            opt.method_1640();
        }
    }

    public static void setMute(AudioState a, boolean mute) {
        String name = a.name.split("\\.")[2];
        for (BaseConfig e : States.CONFIGS) {
            if (e.getType() != ConfigType.BOOLEAN || !e.getKey().split("\\.")[2].equals(name) || !e.getKey().split("\\.")[3].equals("muted")) continue;
            ((BooleanConfig)e).setBoolean(mute);
            a.muted = ((BooleanConfig)e).getBoolean();
            break;
        }
    }

    public static void setUnmuteVolume(AudioState a, int value) {
        String name = a.name.split("\\.")[2];
        for (BaseConfig e : States.CONFIGS) {
            if (e.getType() != ConfigType.INTEGER || !e.getKey().split("\\.")[2].equals(name) || !e.getKey().split("\\.")[3].equals("unmute")) continue;
            ((IntegerConfig)e).setInteger(value);
            a.unmuteVolume = ((IntegerConfig)e).getInteger();
        }
    }
}

