/*
 * Decompiled with CFR 0.152.
 */
package net.treset.audio_hotkeys.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3675;
import net.treset.audio_hotkeys.HotkeyMod;
import net.treset.audio_hotkeys.config.Config;
import net.treset.vanillaconfig.config.KeybindConfig;
import net.treset.vanillaconfig.config.PageConfig;
import net.treset.vanillaconfig.config.base.BaseConfig;
import net.treset.vanillaconfig.config.config_type.ConfigType;
import net.treset.vanillaconfig.tools.FileTools;
import org.lwjgl.glfw.GLFW;

public class MalilibMigration {
    public static void migrateFromMalilib() {
        if (!GLFW.glfwInit()) {
            return;
        }
        File olfFile = new File("./config/audio_hotkeys/audio_hotkeys.json");
        if (!FileTools.fileExists((File)olfFile)) {
            return;
        }
        JsonObject config = FileTools.readJsonFile((File)olfFile);
        if (config == null || !config.isJsonObject()) {
            return;
        }
        Options.init();
        for (BaseConfig p : Config.MAIN_PAGE.getOptions()) {
            p.migrateFrom(Options.getMalilibOptionFromVanillaConfigOption(p.getKey()));
            if (p.getType() != ConfigType.PAGE) continue;
            for (BaseConfig b : ((PageConfig)p).getOptions()) {
                b.migrateFrom(Options.getMalilibOptionFromVanillaConfigOption(b.getKey()));
                if (b.getType() != ConfigType.KEYBIND) continue;
                MalilibMigration.restructureKeybind(config, (PageConfig)p, (KeybindConfig)b);
            }
        }
        MalilibMigration.loadOpenHotkey();
        if (!FileTools.writeJsonToFile((JsonObject)config, (File)new File("./config/audio_hotkeys/audio_hotkeys_tmp.json"))) {
            return;
        }
        Config.MAIN_PAGE.migrateFileFrom("audio_hotkeys/audio_hotkeys_tmp.json");
    }

    public static void loadOpenHotkey() {
        File optionsFile = new File("./options.txt");
        if (optionsFile.exists() && optionsFile.isFile() && optionsFile.canRead()) {
            StringBuilder content = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(optionsFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    class_3675.class_306 key;
                    String keyName;
                    if (!line.startsWith("key_key.audio_hotkeys.config_gui:")) continue;
                    try {
                        keyName = line.substring(33);
                    }
                    catch (IndexOutOfBoundsException e) {
                        br.close();
                        return;
                    }
                    if (keyName.isEmpty()) {
                        return;
                    }
                    try {
                        key = class_3675.method_15981((String)keyName);
                    }
                    catch (IllegalArgumentException e) {
                        br.close();
                        return;
                    }
                    if (key == null) {
                        return;
                    }
                    int keyCode = key.method_1444();
                    int scanCode = -1;
                    try {
                        scanCode = GLFW.glfwGetKeyScancode((int)keyCode);
                    }
                    catch (IllegalStateException e) {
                        br.close();
                        return;
                    }
                    if (scanCode <= 0) {
                        return;
                    }
                    Config.OPEN_CONFIG.setKeys(new int[]{scanCode});
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static JsonObject restructureKeybind(JsonObject obj, PageConfig p, KeybindConfig k) {
        int[] scanKeys;
        JsonObject page = obj.getAsJsonObject(Options.getMalilibOptionFromVanillaConfigOption(p.getKey()));
        if (page == null || !page.isJsonObject()) {
            return obj;
        }
        JsonObject keybind = page.getAsJsonObject(Options.getMalilibOptionFromVanillaConfigOption(k.getKey()));
        if (keybind == null || !keybind.isJsonObject()) {
            return obj;
        }
        JsonPrimitive keysPrim = keybind.getAsJsonPrimitive("keys");
        if (keysPrim == null || !keysPrim.isJsonPrimitive() || !keysPrim.isString()) {
            return obj;
        }
        String keys = keysPrim.getAsString();
        if (keys != null && !keys.isEmpty()) {
            String[] singleKeys = keys.split(",");
            scanKeys = new int[singleKeys.length];
            for (int i = 0; i < scanKeys.length; ++i) {
                try {
                    scanKeys[i] = GLFW.glfwGetKeyScancode((int)Keys.getKeyCodeFromName(singleKeys[i]));
                    continue;
                }
                catch (IllegalStateException e) {
                    return obj;
                }
            }
        } else {
            scanKeys = new int[]{};
        }
        page.remove(Options.getMalilibOptionFromVanillaConfigOption(k.getKey()));
        JsonArray jsonKeys = new JsonArray();
        for (int scanKey : scanKeys) {
            jsonKeys.add((Number)scanKey);
        }
        page.add(Options.getMalilibOptionFromVanillaConfigOption(k.getKey()), (JsonElement)jsonKeys);
        return obj;
    }

    public static class Options {
        public static final Map<String, String> namesToKeys = new HashMap<String, String>();

        public static void init() {
            namesToKeys.put("config.audiohotkeys.master.page", "Master");
            namesToKeys.put("config.audiohotkeys.music.page", "Music");
            namesToKeys.put("config.audiohotkeys.ingame.page", "Ingame");
            namesToKeys.put("config.audiohotkeys.creatures.page", "Creatures");
            namesToKeys.put("config.audiohotkeys.other.page", "Other");
            namesToKeys.put("config.audiohotkeys.master.mute", "Toggle Mute");
            namesToKeys.put("config.audiohotkeys.master.up", "Volume Up");
            namesToKeys.put("config.audiohotkeys.master.down", "Volume Down");
            namesToKeys.put("config.audiohotkeys.master.step", "Volume Step");
            namesToKeys.put("config.audiohotkeys.subtitles.mute", "Toggle Subtitles");
            namesToKeys.put("config.audiohotkeys.music.mute", "Toggle Music Mute");
            namesToKeys.put("config.audiohotkeys.music.up", "Volume Music Up");
            namesToKeys.put("config.audiohotkeys.music.down", "Volume Music Down");
            namesToKeys.put("config.audiohotkeys.music.step", "Volume Music Step");
            namesToKeys.put("config.audiohotkeys.jukebox.mute", "Toggle Jukebox/Note Blocks Mute");
            namesToKeys.put("config.audiohotkeys.jukebox.up", "Volume Jukebox/Note Blocks Up");
            namesToKeys.put("config.audiohotkeys.jukebox.down", "Volume Jukebox/Note Blocks Down");
            namesToKeys.put("config.audiohotkeys.jukebox.step", "Volume Jukebox/Note Blocks Step");
            namesToKeys.put("config.audiohotkeys.environment.mute", "Toggle Environment Mute");
            namesToKeys.put("config.audiohotkeys.environment.up", "Volume Environment Up");
            namesToKeys.put("config.audiohotkeys.environment.down", "Volume Environment Down");
            namesToKeys.put("config.audiohotkeys.environment.step", "Volume Environment Step");
            namesToKeys.put("config.audiohotkeys.weather.mute", "Toggle Weather Mute");
            namesToKeys.put("config.audiohotkeys.weather.up", "Volume Weather Up");
            namesToKeys.put("config.audiohotkeys.weather.down", "Volume Weather Down");
            namesToKeys.put("config.audiohotkeys.weather.step", "Volume Weather Step");
            namesToKeys.put("config.audiohotkeys.blocks.mute", "Toggle Blocks Mute");
            namesToKeys.put("config.audiohotkeys.blocks.up", "Volume Blocks Up");
            namesToKeys.put("config.audiohotkeys.blocks.down", "Volume Blocks Down");
            namesToKeys.put("config.audiohotkeys.blocks.step", "Volume Blocks Step");
            namesToKeys.put("config.audiohotkeys.hostile.mute", "Toggle Hostile Mobs Mute");
            namesToKeys.put("config.audiohotkeys.hostile.up", "Volume Hostile MobsUp");
            namesToKeys.put("config.audiohotkeys.hostile.down", "Volume Hostile Mobs Down");
            namesToKeys.put("config.audiohotkeys.hostile.step", "Volume Hostile Mobs Step");
            namesToKeys.put("config.audiohotkeys.friendly.mute", "Toggle Friendly Mobs Mute");
            namesToKeys.put("config.audiohotkeys.friendly.up", "Volume Friendly Mobs Up");
            namesToKeys.put("config.audiohotkeys.friendly.down", "Volume Friendly Mobs Down");
            namesToKeys.put("config.audiohotkeys.friendly.step", "Volume Friendly Mobs Step");
            namesToKeys.put("config.audiohotkeys.player.mute", "Toggle Players Mute");
            namesToKeys.put("config.audiohotkeys.player.up", "Volume Players Up");
            namesToKeys.put("config.audiohotkeys.player.down", "Volume Players Down");
            namesToKeys.put("config.audiohotkeys.player.step", "Volume Players Step");
            namesToKeys.put("config.audiohotkeys.voice.mute", "Toggle Voice Mute");
            namesToKeys.put("config.audiohotkeys.voice.up", "Volume Voice Up");
            namesToKeys.put("config.audiohotkeys.voice.down", "Volume Voice Down");
            namesToKeys.put("config.audiohotkeys.voice.step", "Volume Voice Step");
        }

        public static String getMalilibOptionFromVanillaConfigOption(String name) {
            if (!namesToKeys.containsKey(name)) {
                return "";
            }
            return namesToKeys.get(name);
        }
    }

    static class Keys {
        private static final Object2IntOpenHashMap<String> MAP_NAME_TO_KEY = new Object2IntOpenHashMap();
        public static final int KEY_NONE = -1;
        public static final int KEY_SPACE = 32;
        public static final int KEY_APOSTROPHE = 39;
        public static final int KEY_COMMA = 44;
        public static final int KEY_MINUS = 45;
        public static final int KEY_PERIOD = 46;
        public static final int KEY_SLASH = 47;
        public static final int KEY_0 = 48;
        public static final int KEY_1 = 49;
        public static final int KEY_2 = 50;
        public static final int KEY_3 = 51;
        public static final int KEY_4 = 52;
        public static final int KEY_5 = 53;
        public static final int KEY_6 = 54;
        public static final int KEY_7 = 55;
        public static final int KEY_8 = 56;
        public static final int KEY_9 = 57;
        public static final int KEY_SEMICOLON = 59;
        public static final int KEY_EQUAL = 61;
        public static final int KEY_A = 65;
        public static final int KEY_B = 66;
        public static final int KEY_C = 67;
        public static final int KEY_D = 68;
        public static final int KEY_E = 69;
        public static final int KEY_F = 70;
        public static final int KEY_G = 71;
        public static final int KEY_H = 72;
        public static final int KEY_I = 73;
        public static final int KEY_J = 74;
        public static final int KEY_K = 75;
        public static final int KEY_L = 76;
        public static final int KEY_M = 77;
        public static final int KEY_N = 78;
        public static final int KEY_O = 79;
        public static final int KEY_P = 80;
        public static final int KEY_Q = 81;
        public static final int KEY_R = 82;
        public static final int KEY_S = 83;
        public static final int KEY_T = 84;
        public static final int KEY_U = 85;
        public static final int KEY_V = 86;
        public static final int KEY_W = 87;
        public static final int KEY_X = 88;
        public static final int KEY_Y = 89;
        public static final int KEY_Z = 90;
        public static final int KEY_LEFT_BRACKET = 91;
        public static final int KEY_BACKSLASH = 92;
        public static final int KEY_RIGHT_BRACKET = 93;
        public static final int KEY_GRAVE_ACCENT = 96;
        public static final int KEY_WORLD_1 = 161;
        public static final int KEY_WORLD_2 = 162;
        public static final int KEY_ESCAPE = 256;
        public static final int KEY_ENTER = 257;
        public static final int KEY_TAB = 258;
        public static final int KEY_BACKSPACE = 259;
        public static final int KEY_INSERT = 260;
        public static final int KEY_DELETE = 261;
        public static final int KEY_RIGHT = 262;
        public static final int KEY_LEFT = 263;
        public static final int KEY_DOWN = 264;
        public static final int KEY_UP = 265;
        public static final int KEY_PAGE_UP = 266;
        public static final int KEY_PAGE_DOWN = 267;
        public static final int KEY_HOME = 268;
        public static final int KEY_END = 269;
        public static final int KEY_CAPS_LOCK = 280;
        public static final int KEY_SCROLL_LOCK = 281;
        public static final int KEY_NUM_LOCK = 282;
        public static final int KEY_PRINT_SCREEN = 283;
        public static final int KEY_PAUSE = 284;
        public static final int KEY_F1 = 290;
        public static final int KEY_F2 = 291;
        public static final int KEY_F3 = 292;
        public static final int KEY_F4 = 293;
        public static final int KEY_F5 = 294;
        public static final int KEY_F6 = 295;
        public static final int KEY_F7 = 296;
        public static final int KEY_F8 = 297;
        public static final int KEY_F9 = 298;
        public static final int KEY_F10 = 299;
        public static final int KEY_F11 = 300;
        public static final int KEY_F12 = 301;
        public static final int KEY_F13 = 302;
        public static final int KEY_F14 = 303;
        public static final int KEY_F15 = 304;
        public static final int KEY_F16 = 305;
        public static final int KEY_F17 = 306;
        public static final int KEY_F18 = 307;
        public static final int KEY_F19 = 308;
        public static final int KEY_F20 = 309;
        public static final int KEY_F21 = 310;
        public static final int KEY_F22 = 311;
        public static final int KEY_F23 = 312;
        public static final int KEY_F24 = 313;
        public static final int KEY_F25 = 314;
        public static final int KEY_KP_0 = 320;
        public static final int KEY_KP_1 = 321;
        public static final int KEY_KP_2 = 322;
        public static final int KEY_KP_3 = 323;
        public static final int KEY_KP_4 = 324;
        public static final int KEY_KP_5 = 325;
        public static final int KEY_KP_6 = 326;
        public static final int KEY_KP_7 = 327;
        public static final int KEY_KP_8 = 328;
        public static final int KEY_KP_9 = 329;
        public static final int KEY_KP_DECIMAL = 330;
        public static final int KEY_KP_DIVIDE = 331;
        public static final int KEY_KP_MULTIPLY = 332;
        public static final int KEY_KP_SUBTRACT = 333;
        public static final int KEY_KP_ADD = 334;
        public static final int KEY_KP_ENTER = 335;
        public static final int KEY_KP_EQUAL = 336;
        public static final int KEY_LEFT_SHIFT = 340;
        public static final int KEY_LEFT_CONTROL = 341;
        public static final int KEY_LEFT_ALT = 342;
        public static final int KEY_LEFT_SUPER = 343;
        public static final int KEY_RIGHT_SHIFT = 344;
        public static final int KEY_RIGHT_CONTROL = 345;
        public static final int KEY_RIGHT_ALT = 346;
        public static final int KEY_RIGHT_SUPER = 347;
        public static final int KEY_MENU = 348;

        Keys() {
        }

        public static int getKeyCodeFromName(String name) {
            return MAP_NAME_TO_KEY.getInt((Object)name);
        }

        static {
            MAP_NAME_TO_KEY.defaultReturnValue(-1);
            for (Field field : Keys.class.getDeclaredFields()) {
                try {
                    String name = field.getName();
                    int keyCode = -1;
                    if (name.startsWith("KEY_")) {
                        name = name.substring(4);
                        keyCode = field.getInt(null);
                    }
                    if (keyCode == -1) continue;
                    MAP_NAME_TO_KEY.put((Object)name, keyCode);
                }
                catch (Exception e) {
                    HotkeyMod.LOGGER.error("Malilib migration failed to initialize the key name lookup!", (Throwable)e);
                }
            }
        }
    }
}

