/*
 * Decompiled with CFR 0.152.
 */
package com.searchablemenus;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class DarkMode {
    private static boolean enabled = false;
    private static boolean disablePanorama = false;
    private static float darkness = 0.6f;
    private static int panoramaColor = -15724528;
    private static float panoramaBrightness = 1.0f;
    private static boolean panoramaGradient = false;
    private static float fadeProgress = 0.0f;
    private static float fadeSpeed = 0.1f;
    private static int buttonX = -135;
    private static int buttonY = 163;
    private static int buttonW = 100;
    private static int buttonH = 20;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void toggle() {
        enabled = !enabled;
    }

    public static void set(boolean value) {
        enabled = value;
    }

    public static float getDarkness() {
        return darkness;
    }

    public static void setDarkness(float value) {
        darkness = Math.max(0.0f, Math.min(1.0f, value));
    }

    public static void updateFade() {
        float target;
        float f = target = enabled ? 1.0f : 0.0f;
        if (fadeProgress < target) {
            fadeProgress = Math.min(fadeProgress + fadeSpeed, target);
        } else if (fadeProgress > target) {
            fadeProgress = Math.max(fadeProgress - fadeSpeed, target);
        }
    }

    public static float getCurrentAlpha() {
        return fadeProgress * darkness;
    }

    public static boolean isVisible() {
        return fadeProgress > 0.01f;
    }

    public static float getFadeSpeed() {
        return fadeSpeed;
    }

    public static void setFadeSpeed(float speed) {
        fadeSpeed = Math.max(0.01f, Math.min(speed, 1.0f));
    }

    public static int getButtonX() {
        return buttonX;
    }

    public static int getButtonY() {
        return buttonY;
    }

    public static int getButtonW() {
        return buttonW;
    }

    public static int getButtonH() {
        return buttonH;
    }

    public static void setButtonX(int x) {
        buttonX = x;
    }

    public static void setButtonY(int y) {
        buttonY = y;
    }

    public static void setButtonW(int w) {
        buttonW = w;
    }

    public static void setButtonH(int h) {
        buttonH = h;
    }

    public static boolean isPanoramaDisabled() {
        return disablePanorama;
    }

    public static void setPanoramaDisabled(boolean value) {
        disablePanorama = value;
    }

    public static int getPanoramaColor() {
        return panoramaColor;
    }

    public static void setPanoramaColor(int color) {
        panoramaColor = color | 0xFF000000;
    }

    public static float getPanoramaBrightness() {
        return panoramaBrightness;
    }

    public static void setPanoramaBrightness(float value) {
        panoramaBrightness = Math.max(0.0f, Math.min(1.0f, value));
    }

    public static boolean isPanoramaGradient() {
        return panoramaGradient;
    }

    public static void setPanoramaGradient(boolean value) {
        panoramaGradient = value;
    }

    public static void isButtonEnabled(Boolean aBoolean) {
    }
}

