/*
 * Decompiled with CFR 0.152.
 */
package com.searchablemenus;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.searchablemenus.DarkMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class SearchablemenusClient
implements ClientModInitializer {
    private static class_304 toggleDarkMode;
    private static final Gson GSON;
    private static int storedKeyCode;

    public void onInitializeClient() {
        SearchablemenusClient.loadConfig();
        toggleDarkMode = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Dark Mode", class_3675.class_307.field_1668, storedKeyCode, "key.categories.misc"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toggleDarkMode.method_1436()) {
                DarkMode.toggle();
                SearchablemenusClient.saveConfig();
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> SearchablemenusClient.saveConfig());
    }

    private static Path configPath() {
        return class_310.method_1551().field_1697.toPath().resolve("config/searchablemenus.json");
    }

    public static void loadConfig() {
        Path p = SearchablemenusClient.configPath();
        if (!Files.exists(p, new LinkOption[0])) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(p);){
            JsonObject o = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            if (o != null) {
                if (o.has("darkMode")) {
                    DarkMode.set(o.get("darkMode").getAsBoolean());
                }
                if (o.has("darkness")) {
                    DarkMode.setDarkness(o.get("darkness").getAsFloat());
                }
                if (o.has("buttonX")) {
                    DarkMode.setButtonX(o.get("buttonX").getAsInt());
                }
                if (o.has("buttonY")) {
                    DarkMode.setButtonY(o.get("buttonY").getAsInt());
                }
                if (o.has("buttonW")) {
                    DarkMode.setButtonW(o.get("buttonW").getAsInt());
                }
                if (o.has("buttonH")) {
                    DarkMode.setButtonH(o.get("buttonH").getAsInt());
                }
                if (o.has("toggleKey")) {
                    storedKeyCode = o.get("toggleKey").getAsInt();
                }
                if (o.has("fadeSpeed")) {
                    DarkMode.setFadeSpeed(o.get("fadeSpeed").getAsFloat());
                }
                if (o.has("disablePanorama")) {
                    DarkMode.setPanoramaDisabled(o.get("disablePanorama").getAsBoolean());
                }
                if (o.has("panoramaColor")) {
                    DarkMode.setPanoramaColor(o.get("panoramaColor").getAsInt());
                }
                if (o.has("panoramaBrightness")) {
                    DarkMode.setPanoramaBrightness(o.get("panoramaBrightness").getAsFloat());
                }
                if (o.has("panoramaGradient")) {
                    DarkMode.setPanoramaGradient(o.get("panoramaGradient").getAsBoolean());
                }
                if (o.has("buttonEnabled")) {
                    DarkMode.setButtonEnabled(o.get("buttonEnabled").getAsBoolean());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveConfig() {
        Path p = SearchablemenusClient.configPath();
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            JsonObject o = new JsonObject();
            o.addProperty("darkMode", Boolean.valueOf(DarkMode.isEnabled()));
            o.addProperty("darkness", (Number)Float.valueOf(DarkMode.getDarkness()));
            o.addProperty("buttonX", (Number)DarkMode.getButtonX());
            o.addProperty("buttonY", (Number)DarkMode.getButtonY());
            o.addProperty("buttonW", (Number)DarkMode.getButtonW());
            o.addProperty("buttonH", (Number)DarkMode.getButtonH());
            o.addProperty("fadeSpeed", (Number)Float.valueOf(DarkMode.getFadeSpeed()));
            o.addProperty("disablePanorama", Boolean.valueOf(DarkMode.isPanoramaDisabled()));
            o.addProperty("panoramaColor", (Number)DarkMode.getPanoramaColor());
            o.addProperty("panoramaBrightness", (Number)Float.valueOf(DarkMode.getPanoramaBrightness()));
            o.addProperty("panoramaGradient", Boolean.valueOf(DarkMode.isPanoramaGradient()));
            o.addProperty("buttonEnabled", Boolean.valueOf(DarkMode.isButtonEnabled()));
            o.addProperty("toggleKey", (Number)storedKeyCode);
            try (BufferedWriter w = Files.newBufferedWriter(p, new OpenOption[0]);){
                GSON.toJson((JsonElement)o, (Appendable)w);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveConfigStatic() {
        SearchablemenusClient.saveConfig();
    }

    public static void updateKeybind(class_3675.class_306 newKey) {
        storedKeyCode = newKey.method_1444();
        toggleDarkMode.method_1422(newKey);
        class_304.method_1426();
        SearchablemenusClient.saveConfig();
    }

    public static class_304 getToggleKeybind() {
        return toggleDarkMode;
    }

    static {
        GSON = new Gson();
        storedKeyCode = 299;
    }
}

