/*
 * Decompiled with CFR 0.152.
 */
package com.searchablemenus.config;

import com.searchablemenus.DarkMode;
import com.searchablemenus.SearchablemenusClient;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SearchableMenusConfigScreen {
    public static class_437 build(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Let There Be Dark Settings")).setSavingRunnable(SearchablemenusClient::saveConfigStatic);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"General"));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Dark Mode"), DarkMode.isEnabled()).setTooltip(new class_2561[]{class_2561.method_43470((String)"If disabled, dark mode will stay off when you exit this menu.")}).setSaveConsumer(DarkMode::set).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43470((String)"Darkness Amount"), DarkMode.getDarkness()).setMin(0.0f).setMax(1.0f).setTooltip(new class_2561[]{class_2561.method_43470((String)"0.0 = no overlay, 1.0 = fully black")}).setSaveConsumer(DarkMode::setDarkness).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43470((String)"Fade Speed"), DarkMode.getFadeSpeed()).setMin(0.01f).setMax(1.0f).setTooltip(new class_2561[]{class_2561.method_43470((String)"Controls how fast dark mode fades in/out. 1.0 = instant toggle, 0.01 = very slow fade")}).setSaveConsumer(DarkMode::setFadeSpeed).build());
        class_304 keybind = SearchablemenusClient.getToggleKeybind();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startKeyCodeField((class_2561)class_2561.method_43470((String)"Toggle Keybind"), keybind.method_1429()).setDefaultValue(keybind.method_1429()).setKeySaveConsumer(newKey -> SearchablemenusClient.updateKeybind(newKey)).build());
        ConfigCategory buttonSettings = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Title Screen Button"));
        buttonSettings.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Button X Offset (from right edge)"), DarkMode.getButtonX()).setTooltip(new class_2561[]{class_2561.method_43470((String)"Negative = move left, Positive = move right")}).setSaveConsumer(DarkMode::setButtonX).build());
        buttonSettings.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Button Y Position"), DarkMode.getButtonY()).setSaveConsumer(DarkMode::setButtonY).build());
        buttonSettings.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Button Width"), DarkMode.getButtonW()).setSaveConsumer(DarkMode::setButtonW).build());
        buttonSettings.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Button Height"), DarkMode.getButtonH()).setSaveConsumer(DarkMode::setButtonH).build());
        buttonSettings.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Show Dark Mode Button"), DarkMode.isButtonEnabled()).setTooltip(new class_2561[]{class_2561.method_43470((String)"If disabled, the Dark Mode button will not appear on the title screen")}).setSaveConsumer(DarkMode::setButtonEnabled).build());
        ConfigCategory panoramaSettings = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Panorama"));
        panoramaSettings.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Disable Panorama"), DarkMode.isPanoramaDisabled()).setTooltip(new class_2561[]{class_2561.method_43470((String)"Replaces the animated panorama with a solid color background on all menus.")}).setSaveConsumer(DarkMode::setPanoramaDisabled).build());
        panoramaSettings.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)class_2561.method_43470((String)"Background Color"), String.format("#%06X", 0xFFFFFF & DarkMode.getPanoramaColor())).setTooltip(new class_2561[]{class_2561.method_43470((String)"Enter a hex color, e.g. #000000 for black, #101010 for dark gray.")}).setSaveConsumer(value -> {
            try {
                int parsed = Integer.parseInt(value.replace("#", ""), 16);
                DarkMode.setPanoramaColor(0xFF000000 | parsed);
            }
            catch (NumberFormatException ignored) {
                DarkMode.setPanoramaColor(-15724528);
            }
        }).build());
        panoramaSettings.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43470((String)"Brightness"), DarkMode.getPanoramaBrightness()).setMin(0.0f).setMax(1.0f).setTooltip(new class_2561[]{class_2561.method_43470((String)"Adjusts how bright the static background appears.")}).setSaveConsumer(DarkMode::setPanoramaBrightness).build());
        panoramaSettings.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Gradient"), DarkMode.isPanoramaGradient()).setTooltip(new class_2561[]{class_2561.method_43470((String)"Applies a subtle vertical gradient to make the background feel less flat.")}).setSaveConsumer(DarkMode::setPanoramaGradient).build());
        return builder.build();
    }
}

