/*
 * Decompiled with CFR 0.152.
 */
package com.roockydev.stackforged.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.roockydev.stackforged.Stackforged;
import com.roockydev.stackforged.config.Config;
import com.roockydev.stackforged.network.PacketHandler;
import com.roockydev.stackforged.network.PacketRequestSort;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="stackforged", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("stackforged", "textures/gui/sort_button.png");
    private static final int BUTTON_WIDTH = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static int buttonX = -1;
    private static int buttonY = -1;
    private static boolean isDragging = false;
    private static double dragOffsetX;
    private static double dragOffsetY;

    @SubscribeEvent
    public static void onRenderScreen(ScreenEvent.Render.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && event.getScreen() instanceof InventoryScreen) {
            ClientEvents.renderButton(event.getGuiGraphics());
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null || !(mc.f_91080_ instanceof InventoryScreen)) {
            return;
        }
        if (event.getButton() != 0) {
            return;
        }
        if (isDragging) {
            return;
        }
        if (mc.f_91074_ != null) {
            boolean isHovered;
            double mouseX = event.getMouseX();
            double mouseY = event.getMouseY();
            boolean bl = isHovered = mouseX >= (double)buttonX && mouseX <= (double)(buttonX + 20) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 20);
            if (isHovered) {
                ClientEvents.handleButtonClick(mc, mouseX, mouseY);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onMouseRelease(ScreenEvent.MouseButtonReleased.Pre event) {
        if (event.getButton() == 0 && isDragging) {
            isDragging = false;
            Config.setButtonPos(buttonX, buttonY);
            event.setCanceled(true);
        }
    }

    private static void renderButton(GuiGraphics guiGraphics) {
        if (buttonX == -1) {
            buttonX = (Integer)Config.BUTTON_X.get();
            buttonY = (Integer)Config.BUTTON_Y.get();
        }
        Minecraft mc = Minecraft.m_91087_();
        double mouseX = mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_();
        double mouseY = mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
        if (isDragging) {
            buttonX = (int)(mouseX - dragOffsetX);
            buttonY = (int)(mouseY - dragOffsetY);
        }
        boolean isHovered = mouseX >= (double)buttonX && mouseX <= (double)(buttonX + 20) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 20);
        int vOffset = isHovered ? 20 : 0;
        guiGraphics.m_280163_(BUTTON_TEXTURE, buttonX, buttonY, 0.0f, (float)vOffset, 20, 20, 20, 40);
    }

    private static void handleButtonClick(Minecraft mc, double mouseX, double mouseY) {
        boolean isAltDown;
        long windowHandle = mc.m_91268_().m_85439_();
        boolean bl = isAltDown = InputConstants.m_84830_((long)windowHandle, (int)342) || InputConstants.m_84830_((long)windowHandle, (int)346);
        if (isAltDown) {
            Stackforged.LOGGER.info("Alt+Click detected. Starting button drag.");
            isDragging = true;
            dragOffsetX = mouseX - (double)buttonX;
            dragOffsetY = mouseY - (double)buttonY;
        } else {
            boolean isShiftDown;
            boolean bl2 = isShiftDown = InputConstants.m_84830_((long)windowHandle, (int)340) || InputConstants.m_84830_((long)windowHandle, (int)344);
            if (isShiftDown) {
                Stackforged.LOGGER.info("Shift+Click detected. Requesting force stack.");
            } else {
                Stackforged.LOGGER.info("Normal Click detected. Requesting simple stack.");
            }
            PacketHandler.INSTANCE.sendToServer((Object)new PacketRequestSort(isShiftDown));
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }
}

