/*
 * Decompiled with CFR 0.152.
 */
package com.roockydev.stackforged.network;

import com.roockydev.stackforged.Stackforged;
import com.roockydev.stackforged.config.Config;
import com.roockydev.stackforged.util.InventorySorter;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketRequestSort {
    private final boolean isShiftDown;

    public PacketRequestSort(boolean isShiftDown) {
        this.isShiftDown = isShiftDown;
    }

    public static void encode(PacketRequestSort msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.isShiftDown);
    }

    public static PacketRequestSort decode(FriendlyByteBuf buf) {
        return new PacketRequestSort(buf.readBoolean());
    }

    public static void handle(PacketRequestSort msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                Stackforged.LOGGER.warn("Received stack packet from null player.");
                return;
            }
            int radius = (Integer)Config.SORT_RADIUS.get();
            boolean sortHotbar = (Boolean)Config.SORT_HOTBAR.get();
            if (msg.isShiftDown) {
                Stackforged.LOGGER.info("Server received force stack request from {}.", (Object)player.m_7755_().getString());
                InventorySorter.forceStack(player, radius, sortHotbar);
            } else {
                Stackforged.LOGGER.info("Server received simple stack request from {}.", (Object)player.m_7755_().getString());
                InventorySorter.stackOnly(player, radius, sortHotbar);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

