/*
 * Decompiled with CFR 0.152.
 */
package com.roockydev.stackforged.util;

import com.roockydev.stackforged.Stackforged;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class InventorySorter {
    public static void stackOnly(ServerPlayer player, int radius, boolean sortHotbar) {
        Stackforged.LOGGER.info("--- Starting Simple Stack to Existing Stacks ---");
        List<IItemHandler> nearbyInventories = InventorySorter.findNearbyInventories((Player)player, radius);
        if (nearbyInventories.isEmpty()) {
            Stackforged.LOGGER.info("No nearby inventories found. Aborting.");
            return;
        }
        PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.m_150109_());
        int startSlot = sortHotbar ? 0 : 9;
        int endSlot = 36;
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack stackInPlayer = playerInv.getStackInSlot(i);
            if (stackInPlayer.m_41619_()) continue;
            ItemStack remaining = InventorySorter.moveToExistingStacks(stackInPlayer, nearbyInventories);
            player.m_150109_().m_6836_(i, remaining);
        }
        Stackforged.LOGGER.info("--- Simple Stack Finished ---");
    }

    public static void forceStack(ServerPlayer player, int radius, boolean sortHotbar) {
        Stackforged.LOGGER.info("--- Starting Force Stack ---");
        List<IItemHandler> nearbyInventories = InventorySorter.findNearbyInventories((Player)player, radius);
        if (nearbyInventories.isEmpty()) {
            Stackforged.LOGGER.info("No nearby inventories found. Aborting.");
            return;
        }
        PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.m_150109_());
        int startSlot = sortHotbar ? 0 : 9;
        int endSlot = 36;
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack stackInPlayer = playerInv.getStackInSlot(i);
            if (stackInPlayer.m_41619_()) continue;
            ItemStack remaining = InventorySorter.moveToExistingStacks(stackInPlayer, nearbyInventories);
            if (!remaining.m_41619_()) {
                remaining = InventorySorter.moveToEmptySlots(remaining, nearbyInventories);
            }
            player.m_150109_().m_6836_(i, remaining);
        }
        Stackforged.LOGGER.info("--- Force Stack Finished ---");
    }

    private static List<IItemHandler> findNearbyInventories(Player player, int radius) {
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        Level level = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-radius, -radius, -radius), (BlockPos)playerPos.m_7918_(radius, radius, radius))) {
            BlockEntity be = level.m_7702_(pos);
            if (be == null) continue;
            be.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handlers::add);
        }
        Stackforged.LOGGER.info("Found {} nearby inventories with item handling capabilities.", (Object)handlers.size());
        return handlers;
    }

    private static ItemStack moveToExistingStacks(ItemStack stack, List<IItemHandler> inventories) {
        ItemStack remaining = stack.m_41777_();
        for (IItemHandler handler : inventories) {
            for (int j = 0; j < handler.getSlots(); ++j) {
                if (handler.getStackInSlot(j).m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)remaining, (ItemStack)handler.getStackInSlot(j)) || !(remaining = handler.insertItem(j, remaining, false)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return remaining;
    }

    private static ItemStack moveToEmptySlots(ItemStack stack, List<IItemHandler> inventories) {
        ItemStack remaining = stack.m_41777_();
        for (IItemHandler handler : inventories) {
            for (int j = 0; j < handler.getSlots(); ++j) {
                if (!handler.getStackInSlot(j).m_41619_() || !(remaining = handler.insertItem(j, remaining, false)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return remaining;
    }
}

