/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandToolStats
implements TabExecutor {
    private final ToolStats toolStats;

    public CommandToolStats(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!sender.hasPermission("toolstats.command")) {
            sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Component)Component.text((String)("ToolStats version " + this.toolStats.getPluginMeta().getVersion() + ". Created by hyperdefined."), (TextColor)NamedTextColor.GREEN));
            return true;
        }
        switch (args[0]) {
            case "reload": {
                if (sender.hasPermission("toolstats.reload")) {
                    boolean oldTokensStatus = this.toolStats.tokens;
                    this.toolStats.loadConfig();
                    this.toolStats.tokenData.getRecipes().clear();
                    this.toolStats.tokenData.setup();
                    if (this.toolStats.tokens != oldTokensStatus) {
                        if (this.toolStats.tokens) {
                            sender.sendMessage((Component)Component.text((String)"It looks like you ENABLED the token system. While this is fine, it can break. Please restart your server instead.", (TextColor)NamedTextColor.YELLOW));
                            if (this.toolStats.config.getBoolean("tokens.craft-token")) {
                                for (ShapedRecipe recipe : this.toolStats.tokenData.getRecipes()) {
                                    Bukkit.addRecipe((Recipe)recipe);
                                }
                            }
                        } else {
                            sender.sendMessage((Component)Component.text((String)"It looks like you DISABLED the token system. While this is fine, it can break. Please restart your server instead.", (TextColor)NamedTextColor.YELLOW));
                            for (ShapedRecipe recipe : this.toolStats.tokenData.getRecipes()) {
                                Bukkit.removeRecipe((NamespacedKey)recipe.getKey());
                            }
                        }
                    }
                    sender.sendMessage((Component)Component.text((String)"Configuration reloaded!", (TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "edit": {
                if (!sender.hasPermission("toolstats.edit")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage((Component)Component.text((String)"Invalid syntax. Usage: /toolstats edit <stat> <value>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.handleEdit(args[1], args[2], (Player)sender);
                return true;
            }
            case "remove": {
                if (!sender.hasPermission("toolstats.remove")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Invalid syntax. Usage: /toolstats remove <stat>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.handleRemove(args[1], (Player)sender);
                return true;
            }
            case "reset": {
                if (!sender.hasPermission("toolstats.reset")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length == 2 && args[1].equalsIgnoreCase("confirm")) {
                    if (!sender.hasPermission("toolstats.reset.confirm")) {
                        sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    Player player = (Player)sender;
                    ItemStack heldItem = player.getInventory().getItemInMainHand();
                    if (!this.toolStats.itemChecker.isValidItem(heldItem.getType())) {
                        sender.sendMessage((Component)Component.text((String)"You must hold a valid item.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    this.fixItemLore(heldItem, player);
                    sender.sendMessage((Component)Component.text((String)"The lore was reset!", (TextColor)NamedTextColor.GREEN));
                    return true;
                }
                sender.sendMessage((Component)Component.text((String)"This will remove ALL current lore from the held item and replace it with the correct lore.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"If the owner of the item is broken, it will reset to the person holding it.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"Only use this if the tags on the tool are incorrect.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"Type /toolstats reset confirm to confirm this.", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "purge": {
                if (!sender.hasPermission("toolstats.purge")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length == 2 && args[1].equalsIgnoreCase("confirm")) {
                    if (!sender.hasPermission("toolstats.purge.confirm")) {
                        sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    Player player = (Player)sender;
                    ItemStack heldItem = player.getInventory().getItemInMainHand();
                    if (!this.toolStats.itemChecker.isValidItem(heldItem.getType())) {
                        sender.sendMessage((Component)Component.text((String)"You must hold a valid item.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    ItemStack purgedItem = this.toolStats.itemLore.removeAll(heldItem, true);
                    player.getInventory().setItemInMainHand(purgedItem);
                    sender.sendMessage((Component)Component.text((String)"The item was purged!", (TextColor)NamedTextColor.GREEN));
                    return true;
                }
                sender.sendMessage((Component)Component.text((String)"This will purge ALL ToolStats data from this item.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"This includes all stats, ownership, and creation time.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"THIS CANNOT BE UNDONE!", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"Type /toolstats purge confirm to confirm this.", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "givetokens": {
                if (!sender.hasPermission("toolstats.givetokens")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage((Component)Component.text((String)"Invalid syntax. Usage: /toolstats givetokens <player> <token>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player target = Bukkit.getPlayerExact((String)args[1]);
                if (target == null) {
                    sender.sendMessage((Component)Component.text((String)"Player not found.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                String tokenType = args[2];
                if (!this.toolStats.tokenData.getTokenTypes().contains(tokenType)) {
                    sender.sendMessage((Component)Component.text((String)"Invalid token type.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (!this.toolStats.config.getBoolean("tokens.enabled")) {
                    sender.sendMessage((Component)Component.text((String)"Unable to give tokens. Tokens are disabled", (TextColor)NamedTextColor.RED));
                    return true;
                }
                int amount = 1;
                if (args.length >= 4) {
                    try {
                        amount = Integer.parseInt(args[3]);
                        if (amount <= 0) {
                            sender.sendMessage((Component)Component.text((String)"Token quantity must be above or 1.", (TextColor)NamedTextColor.RED));
                            return true;
                        }
                    }
                    catch (NumberFormatException exception) {
                        sender.sendMessage((Component)Component.text((String)"Invalid token quantity.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                }
                this.giveToken(target, tokenType, amount);
                if (sender instanceof Player) {
                    sender.sendMessage((Component)Component.text((String)("Gave " + target.getName() + " " + amount + " " + tokenType + " tokens."), (TextColor)NamedTextColor.GREEN));
                }
                return true;
            }
        }
        sender.sendMessage((Component)Component.text((String)"Invalid sub-command.", (TextColor)NamedTextColor.RED));
        return true;
    }

    private void fixItemLore(ItemStack original, Player player) {
        Integer arrows;
        Double damage;
        Integer sheep;
        Integer fish;
        Integer kills;
        Long flightTime;
        Component creationTimeLore;
        Long time;
        ItemStack finalItem = original.clone();
        ItemMeta finalMeta = finalItem.getItemMeta();
        if (finalMeta == null) {
            return;
        }
        PersistentDataContainer container = finalMeta.getPersistentDataContainer();
        ArrayList<Component> lore = new ArrayList<Component>();
        Integer origin = -1;
        if (container.has(this.toolStats.originType, PersistentDataType.INTEGER)) {
            origin = (Integer)container.get(this.toolStats.originType, PersistentDataType.INTEGER);
        }
        if (origin == null) {
            origin = -1;
        }
        if (container.has(this.toolStats.droppedBy, PersistentDataType.STRING) && this.toolStats.config.getBoolean("enabled.dropped-by")) {
            if (container.has(this.toolStats.droppedBy)) {
                String droppedBy = (String)container.get(this.toolStats.droppedBy, PersistentDataType.STRING);
                lore.add(this.toolStats.configTools.formatLore("dropped-by", "{name}", droppedBy));
            } else {
                player.sendMessage((Component)Component.text((String)"Unable to set 'dropped-by', as this item has no record of it."));
            }
        }
        if (container.has(this.toolStats.itemOwner, (PersistentDataType)new UUIDDataType())) {
            Component ownerLore;
            UUID owner = (UUID)container.get(this.toolStats.itemOwner, (PersistentDataType)new UUIDDataType());
            String ownerName = null;
            if (owner != null) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)owner);
                ownerName = offlinePlayer.getName();
            }
            if (ownerName == null) {
                player.sendMessage((Component)Component.text((String)("The owner of this item is null. Setting to " + player.getName() + "."), (TextColor)NamedTextColor.RED));
                ownerName = player.getName();
                container.set(this.toolStats.itemOwner, (PersistentDataType)new UUIDDataType(), (Object)player.getUniqueId());
            }
            if ((ownerLore = this.toolStats.itemLore.formatOwner(ownerName, origin, original)) != null) {
                lore.add(ownerLore);
            }
        }
        if (container.has(this.toolStats.timeCreated, PersistentDataType.LONG) && (time = (Long)container.get(this.toolStats.timeCreated, PersistentDataType.LONG)) != null && (creationTimeLore = this.toolStats.itemLore.formatCreationTime(time, origin, original)) != null) {
            lore.add(creationTimeLore);
        }
        if (this.toolStats.config.getBoolean("enabled.flight-time") && container.has(this.toolStats.flightTime, PersistentDataType.LONG) && (flightTime = (Long)container.get(this.toolStats.flightTime, PersistentDataType.LONG)) != null) {
            Map<String, String> flightTimeFormatted = this.toolStats.numberFormat.formatTime(flightTime);
            Component line = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", flightTimeFormatted);
            lore.add(line);
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "player-kills") && container.has(this.toolStats.playerKills, PersistentDataType.INTEGER) && (kills = (Integer)container.get(this.toolStats.playerKills, PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("kills.player", "{kills}", this.toolStats.numberFormat.formatInt(kills)));
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "mob-kills") && container.has(this.toolStats.mobKills, PersistentDataType.INTEGER) && (kills = (Integer)container.get(this.toolStats.mobKills, PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("kills.mob", "{kills}", this.toolStats.numberFormat.formatInt(kills)));
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "blocks-mined")) {
            Integer blocksMined;
            Integer crops;
            if (original.getType().toString().toLowerCase(Locale.ROOT).contains("hoe") && container.has(this.toolStats.cropsHarvested, PersistentDataType.INTEGER) && (crops = (Integer)container.get(this.toolStats.cropsHarvested, PersistentDataType.INTEGER)) != null) {
                lore.add(this.toolStats.configTools.formatLore("crops-harvested", "{crops}", this.toolStats.numberFormat.formatInt(crops)));
            }
            if (container.has(this.toolStats.blocksMined, PersistentDataType.INTEGER) && (blocksMined = (Integer)container.get(this.toolStats.blocksMined, PersistentDataType.INTEGER)) != null) {
                lore.add(this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", this.toolStats.numberFormat.formatInt(blocksMined)));
            }
        }
        if (this.toolStats.config.getBoolean("enabled.fish-caught") && container.has(this.toolStats.fishCaught, PersistentDataType.INTEGER) && (fish = (Integer)container.get(this.toolStats.fishCaught, PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", this.toolStats.numberFormat.formatInt(fish)));
        }
        if (this.toolStats.config.getBoolean("enabled.sheep-sheared") && container.has(this.toolStats.sheepSheared, PersistentDataType.INTEGER) && (sheep = (Integer)container.get(this.toolStats.sheepSheared, PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", this.toolStats.numberFormat.formatInt(sheep)));
        }
        if (this.toolStats.config.getBoolean("enabled.armor-damage") && container.has(this.toolStats.armorDamage, PersistentDataType.DOUBLE) && (damage = (Double)container.get(this.toolStats.armorDamage, PersistentDataType.DOUBLE)) != null) {
            lore.add(this.toolStats.configTools.formatLore("damage-taken", "{damage}", this.toolStats.numberFormat.formatDouble(damage)));
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "damage-done") && container.has(this.toolStats.damageDone, PersistentDataType.DOUBLE) && (damage = (Double)container.get(this.toolStats.damageDone, PersistentDataType.DOUBLE)) != null) {
            lore.add(this.toolStats.configTools.formatLore("damage-done", "{damage}", this.toolStats.numberFormat.formatDouble(damage)));
        }
        if (this.toolStats.config.getBoolean("enabled.arrows-shot") && container.has(this.toolStats.arrowsShot, PersistentDataType.INTEGER) && (arrows = (Integer)container.get(this.toolStats.arrowsShot, PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", this.toolStats.numberFormat.formatInt(arrows)));
        }
        finalMeta.lore(lore);
        finalItem.setItemMeta(finalMeta);
        int slot = player.getInventory().getHeldItemSlot();
        player.getInventory().setItem(slot, finalItem);
    }

    private void giveToken(Player target, String tokenType, int amount) {
        ItemStack token = this.toolStats.tokenData.createToken(tokenType);
        token.setAmount(amount);
        target.getInventory().addItem(new ItemStack[]{token});
    }

    private void handleEdit(String stat, Object userValue, Player player) {
        ItemStack editedItem = player.getInventory().getItemInMainHand().clone();
        if (!this.toolStats.itemChecker.isValidItem(editedItem.getType())) {
            player.sendMessage((Component)Component.text((String)"This is not a valid item.", (TextColor)NamedTextColor.RED));
            return;
        }
        ItemMeta editedItemMeta = editedItem.getItemMeta();
        PersistentDataContainer container = editedItemMeta.getPersistentDataContainer();
        switch (stat) {
            case "crops-harvested": {
                if (!this.toolStats.config.getBoolean("enabled.crops-harvested")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.cropsHarvested)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.cropsHarvested, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateCropsMined(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "blocks-mined": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "blocks-mined")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.blocksMined)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.blocksMined, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateBlocksMined(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-taken": {
                if (!this.toolStats.config.getBoolean("enabled.armor-damage")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.armorDamage)) {
                    double value;
                    try {
                        value = Double.parseDouble((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0.0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Double statValue = (Double)container.get(this.toolStats.armorDamage, PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    double difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateArmorDamage(editedItem, difference, false);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-done": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "damage-done")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.damageDone)) {
                    double value;
                    try {
                        value = Double.parseDouble((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0.0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Double statValue = (Double)container.get(this.toolStats.damageDone, PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    double difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateWeaponDamage(editedItem, difference, false);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "mob-kills": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "mob-kills")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.mobKills)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.mobKills, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateMobKills(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "player-kills": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "player-kills")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.playerKills)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.playerKills, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updatePlayerKills(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "arrows-shot": {
                if (!this.toolStats.config.getBoolean("enabled.arrows-shot")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.arrowsShot)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.arrowsShot, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateArrowsShot(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "sheep-sheared": {
                if (!this.toolStats.config.getBoolean("enabled.sheep-sheared")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.sheepSheared)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.sheepSheared, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateSheepSheared(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "flight-time": {
                if (!this.toolStats.config.getBoolean("enabled.flight-time")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.flightTime)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Long statValue = (Long)container.get(this.toolStats.flightTime, PersistentDataType.LONG);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    long difference = (long)value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateFlightTime(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "fight-caught": {
                if (!this.toolStats.config.getBoolean("enabled.fight-caught")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.fishCaught)) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.fishCaught, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateFishCaught(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            default: {
                player.sendMessage((Component)Component.text((String)"That is not a valid stat to update.", (TextColor)NamedTextColor.RED));
                return;
            }
        }
        editedItem.setItemMeta(editedItemMeta);
        player.getInventory().setItemInMainHand(editedItem);
        player.sendMessage((Component)Component.text((String)("Updated stat " + stat + " for held item!"), (TextColor)NamedTextColor.GREEN));
    }

    private void handleRemove(String stat, Player player) {
        ItemStack editedItem = player.getInventory().getItemInMainHand().clone();
        if (!this.toolStats.itemChecker.isValidItem(editedItem.getType())) {
            player.sendMessage((Component)Component.text((String)"This is not a valid item.", (TextColor)NamedTextColor.RED));
            return;
        }
        ItemMeta editedItemMeta = editedItem.getItemMeta();
        PersistentDataContainer container = editedItemMeta.getPersistentDataContainer();
        switch (stat) {
            case "crops-harvested": {
                if (container.has(this.toolStats.cropsHarvested)) {
                    Integer statValue = (Integer)container.get(this.toolStats.cropsHarvested, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.cropsHarvested);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "crops-mined");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "blocks-mined": {
                if (container.has(this.toolStats.blocksMined)) {
                    Integer statValue = (Integer)container.get(this.toolStats.blocksMined, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.blocksMined);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "blocks-mined");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-taken": {
                if (container.has(this.toolStats.armorDamage)) {
                    Double statValue = (Double)container.get(this.toolStats.armorDamage, PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.armorDamage);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "damage-taken");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("damage-taken", "{damage}", this.toolStats.numberFormat.formatDouble(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-done": {
                if (container.has(this.toolStats.damageDone)) {
                    Double statValue = (Double)container.get(this.toolStats.damageDone, PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.damageDone);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "damage-done");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("damage-done", "{damage}", this.toolStats.numberFormat.formatDouble(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "mob-kills": {
                if (container.has(this.toolStats.mobKills)) {
                    Integer statValue = (Integer)container.get(this.toolStats.mobKills, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.mobKills);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "mob-kills");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("kills.mob", "{kills}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "player-kills": {
                if (container.has(this.toolStats.playerKills)) {
                    Integer statValue = (Integer)container.get(this.toolStats.playerKills, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.playerKills);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "player-kills");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("kills.player", "{kills}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "sheep-sheared": {
                if (container.has(this.toolStats.sheepSheared)) {
                    Integer statValue = (Integer)container.get(this.toolStats.sheepSheared, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.sheepSheared);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "sheep-sheared");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "flight-time": {
                if (container.has(this.toolStats.flightTime)) {
                    Long statValue = (Long)container.get(this.toolStats.flightTime, PersistentDataType.LONG);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.flightTime);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "flight-time");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Map<String, String> timeFormatted = this.toolStats.numberFormat.formatTime(statValue);
                    Component oldLine = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", timeFormatted);
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "fight-caught": {
                if (container.has(this.toolStats.fishCaught)) {
                    Integer statValue = (Integer)container.get(this.toolStats.fishCaught, PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.fishCaught);
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "fight-caught");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.tokenApplied);
                    } else {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            default: {
                player.sendMessage((Component)Component.text((String)"That is not a valid stat to update.", (TextColor)NamedTextColor.RED));
                return;
            }
        }
        editedItem.setItemMeta(editedItemMeta);
        player.getInventory().setItemInMainHand(editedItem);
        player.sendMessage((Component)Component.text((String)("Removed stat " + stat + " for held item!"), (TextColor)NamedTextColor.GREEN));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (sender.hasPermission("toolstats.reload")) {
                suggestions.add("reload");
            }
            if (sender.hasPermission("toolstats.reset")) {
                suggestions.add("reset");
            }
            if (sender.hasPermission("toolstats.givetokens")) {
                suggestions.add("givetokens");
            }
            if (sender.hasPermission("toolstats.edit")) {
                suggestions.add("edit");
            }
            if (sender.hasPermission("toolstats.remove")) {
                suggestions.add("remove");
            }
            if (sender.hasPermission("toolstats.purge")) {
                suggestions.add("purge");
            }
            return suggestions.isEmpty() ? null : suggestions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("reset") && sender.hasPermission("toolstats.reset.confirm")) {
            return Collections.singletonList("confirm");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("purge") && sender.hasPermission("toolstats.purge.confirm")) {
            return Collections.singletonList("confirm");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("edit") && sender.hasPermission("toolstats.edit")) {
            return this.toolStats.tokenData.getTokenTypes().stream().filter(s -> !s.equals("remove") && !s.equals("reset")).map(s -> s.equals("crops-mined") ? "crops-harvested" : s).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove") && sender.hasPermission("toolstats.remove")) {
            return this.toolStats.tokenData.getTokenTypes().stream().filter(s -> !s.equals("remove") && !s.equals("reset")).map(s -> s.equals("crops-mined") ? "crops-harvested" : s).collect(Collectors.toList());
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("givetokens") && sender.hasPermission("toolstats.givetokens")) {
            return this.toolStats.tokenData.getTokenTypes();
        }
        return null;
    }
}

