/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CraftItem
implements Listener {
    private final ToolStats toolStats;

    public CraftItem(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraft(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        ItemStack craftedItem = event.getCurrentItem();
        if (craftedItem == null || craftedItem.getType() == Material.AIR) {
            return;
        }
        Material craftedMaterial = craftedItem.getType();
        if (!this.toolStats.itemChecker.isValidItem(craftedMaterial)) {
            return;
        }
        if (event.isShiftClick()) {
            ItemStack[] beforeCraft = player.getInventory().getContents();
            player.getScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> {
                ItemStack[] afterCraft = player.getInventory().getContents();
                for (int i = 0; i < afterCraft.length; ++i) {
                    ItemStack newItem;
                    ItemStack newSlotItem = afterCraft[i];
                    ItemStack oldSlotItem = beforeCraft[i];
                    if (newSlotItem == null || newSlotItem.getType() != craftedMaterial || oldSlotItem != null || (newItem = this.addCraftOrigin(newSlotItem, player)) == null) continue;
                    player.getInventory().setItem(i, newItem);
                }
            }, null, 1L);
            return;
        }
        ItemStack newItem = this.addCraftOrigin(craftedItem, player);
        if (newItem != null) {
            event.setCurrentItem(newItem);
        }
    }

    private ItemStack addCraftOrigin(ItemStack itemStack, Player owner) {
        Component itemOwner;
        PersistentDataContainer container;
        ItemStack newItem = itemStack.clone();
        ItemMeta meta = newItem.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)itemStack);
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        if ((container = meta.getPersistentDataContainer()).has(this.toolStats.timeCreated, PersistentDataType.LONG) || container.has(this.toolStats.itemOwner, PersistentDataType.LONG)) {
            return null;
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 0, newItem);
        if (creationDate != null) {
            container.set(this.toolStats.timeCreated, PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)0);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 0, newItem)) != null) {
            container.set(this.toolStats.itemOwner, (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)0);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(newItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.hash, PersistentDataType.STRING, (Object)hash);
        }
        newItem.setItemMeta(meta);
        return newItem;
    }
}

