/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import lol.hyper.toolstats.ToolStats;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class EntityDeath
implements Listener {
    private final ToolStats toolStats;

    public EntityDeath(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            return;
        }
        UUID livingEntityUUID = event.getEntity().getUniqueId();
        if (this.toolStats.mobKill.trackedMobs.contains(livingEntityUUID)) {
            for (int i = 0; i < event.getDrops().size(); ++i) {
                ItemStack newItem;
                PersistentDataContainer container;
                ItemStack droppedItem = (ItemStack)event.getDrops().get(i);
                ItemMeta droppedItemMeta = droppedItem.getItemMeta();
                if (droppedItemMeta != null && (container = droppedItemMeta.getPersistentDataContainer()).has(this.toolStats.originType, PersistentDataType.INTEGER) || !this.toolStats.itemChecker.isValidItem(droppedItem.getType()) || (newItem = this.addLore(droppedItem, livingEntity)) == null) continue;
                event.getDrops().set(i, newItem);
            }
            this.toolStats.mobKill.trackedMobs.remove(livingEntityUUID);
        }
    }

    private ItemStack addLore(ItemStack oldItem, LivingEntity entity) {
        ItemStack newItem = oldItem.clone();
        ItemMeta meta = newItem.getItemMeta();
        if (meta == null) {
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String mobName = this.toolStats.config.getString("messages.mob." + String.valueOf(entity.getType()));
        if (mobName == null) {
            mobName = entity.getName();
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 1, newItem);
        if (creationDate != null) {
            container.set(this.toolStats.timeCreated, PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)1);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("enabled.dropped-by")) {
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)1);
            container.set(this.toolStats.droppedBy, PersistentDataType.STRING, (Object)mobName);
            Component droppedBy = this.toolStats.configTools.formatLore("dropped-by", "{name}", mobName);
            lore.add(droppedBy);
        }
        meta.lore(lore);
        newItem.setItemMeta(meta);
        return newItem;
    }
}

