/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GenerateLoot
implements Listener {
    private final ToolStats toolStats;

    public GenerateLoot(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGenerateLoot(LootGenerateEvent event) {
        StorageMinecart mineCart;
        Player player;
        InventoryHolder inventoryHolder = event.getInventoryHolder();
        if (inventoryHolder == null) {
            return;
        }
        Location lootLocation = event.getLootContext().getLocation();
        if (inventoryHolder instanceof Chest) {
            Block openedChest = null;
            for (Block chest : this.toolStats.playerInteract.openedChests.keySet()) {
                double distance;
                Location chestLocation = chest.getLocation();
                if (chest.getWorld() != lootLocation.getWorld() || !((distance = lootLocation.distance(chestLocation)) <= 1.0)) continue;
                openedChest = chest;
            }
            if (openedChest == null) {
                return;
            }
            player = this.toolStats.playerInteract.openedChests.get(openedChest);
            this.setLoot(event.getLoot(), player);
        }
        if (inventoryHolder instanceof StorageMinecart && this.toolStats.playerInteract.openedMineCarts.containsKey(mineCart = (StorageMinecart)inventoryHolder)) {
            player = this.toolStats.playerInteract.openedMineCarts.get(mineCart);
            this.setLoot(event.getLoot(), player);
        }
    }

    private ItemStack addLootedOrigin(ItemStack itemStack, Player owner) {
        Component itemOwner;
        PersistentDataContainer container;
        ItemStack newItem = itemStack.clone();
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        if ((container = meta.getPersistentDataContainer()).has(this.toolStats.timeCreated, PersistentDataType.LONG) || container.has(this.toolStats.itemOwner, PersistentDataType.LONG)) {
            return null;
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 2, newItem);
        if (creationDate != null) {
            container.set(this.toolStats.timeCreated, PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)2);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 2, newItem)) != null) {
            container.set(this.toolStats.itemOwner, (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)2);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(newItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.hash, PersistentDataType.STRING, (Object)hash);
        }
        newItem.setItemMeta(meta);
        return newItem;
    }

    private void setLoot(List<ItemStack> loot, Player player) {
        for (int i = 0; i < loot.size(); ++i) {
            ItemStack newItem;
            ItemStack itemStack = loot.get(i);
            if (itemStack == null || itemStack.getType() == Material.AIR || !this.toolStats.itemChecker.isValidItem(itemStack.getType()) || (newItem = this.addLootedOrigin(itemStack, player)) == null) continue;
            loot.set(i, newItem);
        }
    }
}

